functor RecMutex (Thread : THREAD) : REC_MUTEX =
    struct
	datatype thread_id = ID of unit ref
	fun new_id () = ID (ref ())

	val self = Thread.var (new_id ())

	fun me () =
	    Thread.get self
	    handle Undefined =>
		let val id = new_id ()
		in
		    Thread.set self id;
		    id
		end

	datatype T = RM of { owner : thread_id ref,
			     count : int ref,
			     mutex : Thread.mutex }

	fun new () = RM { owner = ref (me ()),
			  count = ref 0,
			  mutex = Thread.mutex () }
	    
	fun lock (RM { owner, count, mutex }) =
	    if !count = 0 orelse !owner <> me () then
		(Thread.acquire mutex;
		 count := 1;
		 owner := me ())
	    else
		inc count

	exception NotOwner

	fun unlock (RM { owner, count, mutex }) =
	    if !count = 0 orelse !owner <> me () then
		raise NotOwner
	    else if !count = 1 then
		(Thread.release mutex;
		 dec count)
	    else
		dec count
    end
