(* $Id: group-base.sml,v 1.1 1992/07/01 22:22:28 felty Exp $ *)
local open SourceGroup 
      fun concatDir name = ("/usr/misc/.sml/tools/mlyacc/base/" ^ name)
      val files = map concatDir
                    ["base.sig", "join.sml", "joinWithArg.sml",
                     "lrtable.sml", "parserGen.sml", "stream.sml"]
in
  val baseGroup = create [Automatic files, Connections [concatDir "conn-base"]]
end





(* If you reference baseGroup as a library of another group, G, then
   the first time you make G, the target files and the link file for baseGroup
   will be loaded into the environment.  For example:

SMLTool.targetNamer := SourceAction.sysBinary; (* To find the base targets *)

(* val baseGroup *) use "/usr/misc/.sml/tools/mlyacc/base/group-base.sml";

local open SourceGroup (* See /afs/cs/project/venari-2/gentrav/def.sml *)
      val files = ["absyn.sig", "absyn.sml", "generate.sml",
                   "interface.sig", "interface.sml", "parse.sig", "parse.sml"]
in
  val genGroup = create [Automatic files, Library [baseGroup]]
end

SourceGroup.make SourceAction.doCompile genGroup;
 (* Recursively calls SourceGroup.make SourceAction.doLoadLibrary baseGroup;
    then does the work for genGroup *)

*)
