(*Handling of conditional meta-rewrites -- NOT CURRENTLY REQUIRED*)

(*If condth has the form A==>B then recurs on B assuming A.
  It finally discharges these assumptions from result of applying mrule.*)
fun cond_infer mrule condth =
  case #prop(rep_thm condth) of
	imp$A$B => 
	  if imp=implies then  
	    let val cA = Sign.cterm_of (#sign(rep_thm condth)) A
	    in  implies_intr cA
		  (cond_infer mrule (implies_elim condth (assume cA)))
	    end
	  else mrule condth
    | _ => mrule condth;


fun free_of_var (Var((a,_), T)) = Free(a,T)
  | free_of_var t = raise TERM_ERROR with ("free_of_var", [t]);


(*Freezes a theorem by changing Vars to Frees, e.g. "?a" to "a". *)
fun freeze th =
    let val {sign,prop,...} = rep_thm th;
	val vars = Logic.add_term_vars (prop, []);
	val frees = map free_of_var vars;
	val ct_of = map (Sign.cterm_of sign)
    in  instantiate (ct_of vars ~~ ct_of frees) th  end;


(*  phi==psi  
  ------------
    phi==>psi  *)
fun iff_imp_implies eqth = 
  let val {sign,prop,...} = rep_thm eqth;
      val cleft = Sign.cterm_of sign (fst (Logic.dest_equals prop))
  in implies_intr cleft
       (equal_props eqth (assume cleft))
  end;


(*      a==b 
  -----------------
  psi(b) ==> psi(a)         *)
fun subst_orule eqth =
  let val {sign,prop,...} = rep_thm eqth;
      val T = type_of (fst (Logic.dest_equals prop));
      val refth = reflexive (Sign.cterm_of sign (Free("phi", T-->Aprop)));
  in  iff_imp_implies (symmetric (combination refth eqth))  end;
 

(*   Phi ==> a==b 
  -------------------------
  Phi ==> psi(b) ==> psi(a)     

  Resolution with this unfolds a free occurrence of "a" in a goal.*)
fun cond_rewriting_rule eqth =
    standard (cond_infer subst_orule (freeze eqth));





val None_unfold = cond_rewriting_rule None_def;
val Some_unfold = cond_rewriting_rule Some_def;
