(*  Title: 	LK/set/ex/pairing
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Set theory: unordered and ordered pairs, uniqueness of pairing*)

(*Uniqueness of singletons*)
val prems = 
goal Set_Rule.thy "$H, $G, a=b |- $E ==> $H, {a} = {b}, $G |- $E";
by (resolve_tac [cut] 1);
by (thin_tac 2  THEN  resolve_tac prems 2);
by (resolve_tac [eqext_left_thin] 1);
by (set_tac 2); 
by (set_tac 1); 
val equal_single_left = result();

(*For solving reversed assumptions*)
goal Set_Rule.thy "$H, a=b, $G |- $E, b=a, $F";
by (resolve_tac [sym] 1);
by (resolve_tac [basic] 1);
val sym_basic = result();


(*The key lemma in various forms*)

val prems = 
goal Set_Rule.thy
    "[| $H, $G, a = c, b = d |- $E;  $H, $G, a = d, b = c |- $E |] \
\    ==> $H, {a,b} = {c,d}, $G |- $E";
by (cut_left_tac "a=c & b=d  |  a=d & b=c" 1);
by (reresolve_tac [equal_left_s, setcons_left_s, subset_null_left] 1);
by (reresolve_tac [basic, sym_basic, null_left, setcons_left,
		       conj_right, disj_right] 1);
(*26 secs*)
by (REPEAT (resolve_tac (prems@ [conj_left,disj_left]) 1));
val equal_double_left = result();


val prems = 
goal Set_Rule.thy 
    "$H, $G, a = c, b = c |- $E ==> $H, {a,b} = {c}, $G |- $E";
by (cut_left_tac "a=c & b=c" 1);
by (reresolve_tac [equal_left_s, setcons_left_s, subset_null_left] 1);
by (reresolve_tac [basic, sym_basic, null_left, setcons_left,
		       conj_right, disj_right] 1);
by (REPEAT (resolve_tac (prems@[conj_left]) 1));
val equal_ds_left = result();


val prems = 
goal Set_Rule.thy 
    "$H, $G, a = c, b = c |- $E ==> $H, {c} = {a,b}, $G |- $E";
by (resolve_tac [sym_left] 1);
by (REPEAT (resolve_tac (prems@[equal_ds_left]) 1));
val equal_sd_left = result();


val prems = 
goal Set_Rule.thy 
    "$H, $G, a = c, b = d |- $E  ==>  $H, <a,b> = <c,d>, $G |- $E";
by (cut_left_tac "a=c  &  b=d" 1);
by (rewrite_goals_tac [Pair_def]);
by (reresolve_tac
     [sym_basic, basic, conj_right, 
      equal_single_left, equal_double_left, equal_ds_left, equal_sd_left] 1);
by (resolve_tac [trans] 2);
by (resolve_tac [trans] 2);
by (resolve_tac [trans] 1);
by (resolve_tac [trans] 1);
by (REPEAT (resolve_tac (prems@[basic, sym_basic, conj_left]) 1));
val equal_pairs_left = result();

writeln"Reached end of file.";
