(*  Title: 	HOL/ex/quant
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Classical HOL: examples with quantifiers.  Can be read to test the system.

All these examples are really first-order.
They permit comparison with the first-order systems NJ and LK.

size_of_state (topthm());
by (Pc.onestep_tac 1);
by (Pc.step_tac asms 1);
by (Pc.comp_step_tac asms);
by (Pc.comp_tac asms);
*)

writeln"HOL/ex/quant: Examples with quantifiers";


val asms =
goal HOL_Rule.thy
    "(ALL x:A.ALL y:B.P(x,y))  <->  (ALL y:B.ALL x:A.P(x,y))";
by (Pc.fast_tac asms 1);
result(); 


val asms =
goal HOL_Rule.thy
    "(ALL u:A.P(u)) & (ALL v:B.Q(v)) --> (ALL u:A.ALL v:B. P(u) & Q(v))";
by (Pc.fast_tac asms 1);
result(); 


writeln"Permutation of EXISTS.";
val asms =
goal HOL_Rule.thy  "(EX x:A.EX y:B.P(x,y)) <-> (EX y:B.EX x:A.P(x,y))";
by (Pc.fast_tac asms 1);
result(); 

val asms =
goal HOL_Rule.thy
    "(ALL x:A. P(x) & Q(x)) <-> (ALL x:A. P(x))  &  (ALL x:A. Q(x))";
by (Pc.fast_tac asms 1);
result(); 

(*Converse is invalid*)
val asms =
goal HOL_Rule.thy
    "(ALL x:A. P(x))  |  (ALL x:A. Q(x)) --> (ALL x:A. P(x) | Q(x))";
by (Pc.fast_tac asms 1);
result(); 

writeln"Pushing ALL into an implication.";
val asms =
goal HOL_Rule.thy  "(ALL x:A. P --> Q(x))  <->  (P --> (ALL x:A. Q(x)))";
by (Pc.fast_tac asms 1);
result(); 

val asms =
goal HOL_Rule.thy  "(ALL x:A.P(x)-->Q)  <->  ((EX x:A.P(x)) --> Q)";
by (Pc.fast_tac asms 1);
result(); 


writeln"Distribution of EX over disjunction.";
val asms =
goal HOL_Rule.thy  "(EX x:A. P(x) | Q(x)) <-> (EX x:A.P(x)) | (EX x:A.Q(x))";
by (Pc.fast_tac asms 1);
result(); 


(*Converse is invalid*)
val asms =
goal HOL_Rule.thy  "(EX x:A. P(x) & Q(x)) --> (EX x:A.P(x)) & (EX x:A.Q(x))";
by (Pc.fast_tac asms 1);
result(); 


writeln"Vacuous quantification.";

(*In these two the assumption a:A is essential; else type A could be empty.*) 
val asms =
goal HOL_Rule.thy "a: A ==> (ALL x:A. P) <-> P";
by (Pc.fast_tac asms 1);
result(); 

val asms =
goal HOL_Rule.thy
    "a: A ==> (EX x:A. P)  <->  P";
by (Pc.fast_tac asms 1);
result(); 

(*FALSE*)
val asms =
goal HOL_Rule.thy "EX x:A. form(True)";
by (Pc.fast_tac asms 1) handle ERROR => writeln"Failed, as expected";
(*Check that subgoals remain: proof failed.*)
getgoal 1;  

val asms =
goal HOL_Rule.thy "ALL x:A. EX y:A. form(True)";
by (Pc.fast_tac asms 1);
result(); 

writeln"Harder examples: classical theorems.";

(*More vacuous quantification below...*)

val asms =
goal HOL_Rule.thy
    "a: A ==> (ALL x:A. Q(x))  -->  (EX x:A. Q(x))";
by (Pc.fast_tac asms 1);
result();  


val asms =
goal HOL_Rule.thy
    "a: A ==> (EX x:A. P-->Q(x))  <->  (P --> (EX x:A.Q(x)))";
by (Pc.fast_tac asms 1);
result(); 


val asms =
goal HOL_Rule.thy
    "a: A ==> (EX x:A.P(x)-->Q)  <->  (ALL x:A.P(x)) --> Q";
by (Pc.fast_tac asms 1);
result(); 


val asms =
goal HOL_Rule.thy
    "(ALL x:A.P(x)) | Q  <->  (ALL x:A. P(x) | Q)";
by (Pc.fast_tac asms 1);
result(); 


writeln"Basic test of quantifier reasoning";
val asms =
goal HOL_Rule.thy
    "(EX y:B. ALL x:A. Q(x,y)) --> (ALL x:A. EX y:B. Q(x,y))";
by (Pc.fast_tac asms 1);
result();  


writeln"The following are invalid!";

(*FALSE*)
val asms =
goal HOL_Rule.thy
    "(ALL x:A. EX y:B. Q(x,y)) --> (EX y:B. ALL x:A. Q(x,y))";
by (Pc.fast_tac asms 1) handle ERROR => writeln"Failed, as expected";
(*Check that subgoals remain: proof failed.*)
getgoal 1;  

(*FALSE*)
val asms =
goal HOL_Rule.thy
    "(EX x:A. Q(x))  -->  (ALL x:A. Q(x))";
by (Pc.fast_tac asms 1) handle ERROR => writeln"Failed, as expected";
getgoal 1; 

(*FALSE since we are not given a:A*)
val asms =
goal HOL_Rule.thy
    "(ALL x:A. Q(x))  -->  (EX x:A. Q(x))";
by (Pc.fast_tac asms 1) handle ERROR => writeln"Failed, as expected";
getgoal 1; 



writeln"More and more examples...";

val asms =
goal HOL_Rule.thy
    "(ALL x:A. P(x)-->Q(x)) & (EX x:A.P(x)) --> (EX x:A.Q(x))";
by (Pc.fast_tac asms 1);
result();  


val asms =
goal HOL_Rule.thy
    "(P--> (EX x:A.Q(x))) & P--> (EX x:A.Q(x))";
by (Pc.fast_tac asms 1);
result();  


writeln"Solving for a Var, assigns g(f(d)) to ?a";
val asms =
goal HOL_Rule.thy
    "[| !x.x:A ==> f(x): B;  !y.y:B ==> g(y): C;  d:A |] ==>  \
\    (ALL x:A. P(x)-->Q(f(x))) & (ALL y:B. Q(y)-->R(g(y))) & P(d) -->  R(?a)";
by (Pc.fast_tac asms 1);
uresult();


writeln"Testing the complete tactic";

(*Not provable by pc_tac: needs multiple instantiation of ALL.
  Could be proved trivially by a PROLOG interpreter*)
val asms =
goal HOL_Rule.thy
    "[| d: A;  !x.x: A ==> f(x) : A |] ==>  \
\    (ALL x:A. P(x)-->P(f(x)))  &  P(d)-->P(f(f(f(d))))";
by (Pc.comp_tac asms);
result();


(*Not provable by pc_tac: needs double instantiation of EXISTS*)
val asms =
goal HOL_Rule.thy  "[| a : A;  b : A |] ==> EX x:A. P(x) --> P(a) & P(b)";
by (Pc.comp_tac asms);
result();

(*The assumption a:A is essential*)
val asms =
goal HOL_Rule.thy  "a : A ==> EX x:A. P(x) --> (ALL y:A. P(y))";
by (Pc.comp_tac asms);
result();


writeln"More fallacies";

val asms =
goal HOL_Rule.thy
    "P(?a) --> (ALL x:A.P(x))";
by (Pc.fast_tac asms 1) handle ERROR => writeln"Failed, as expected";
getgoal 1;  (*Check that subgoals remain: proof failed.*)


val asms =
goal HOL_Rule.thy
    "(P(?a) --> (ALL x:A.Q(x))) --> (ALL x:A. P(x) --> Q(x))";
by (Pc.fast_tac asms 1) handle ERROR => writeln"Failed, as expected";
getgoal 1;  


writeln"Principia Mathematica *11.53";
val asms =
goal HOL_Rule.thy
  "(ALL x:A. ALL y:B. P(x) --> Q(y)) <-> ((EX x:A. P(x)) --> (ALL y:B. Q(y)))";
by (Pc.fast_tac asms 1);
result();


writeln"Principia Mathematica *11.55";
val asms =
goal HOL_Rule.thy
    "(EX x:A. EX y:B. P(x) & Q(x,y))  <-> (EX x:A. P(x) & (EX y:B. Q(x,y)))";
by (Pc.fast_tac asms 1);
result();


writeln"Principia Mathematica *11.61";
val asms =
goal HOL_Rule.thy
  "(EX y:B. ALL x:A. P(x)-->Q(x,y)) --> (ALL x:A. P(x) --> (EX y:B. Q(x,y)))";
by (Pc.fast_tac asms 1);
result();


writeln"Reached end of file.";
(*16 August 1988: loaded this file in 200 secs*)
(*21 August 1988: loaded this file in 102 secs*)
(*10 September 1988: loaded this file in 66 secs*)
