(*  Title: 	FOL/pc
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Classical Theorem Prover for Predicate Calculus
*)

(*Propositional rules*)
val prop_rulepairs =
  [ (asm_rl,"safe_elim"),       (*!solves goals by assumption!*)
    (conj_intr,"safe_intr"),
    (disj_cintr,"safe_intr"),
    (imp_intr,"safe_intr"),
    (not_intr,"safe_intr"),
    (iff_intr,"safe_intr"),
    (False_elim,"safe_elim"),
    (conj_elim,"safe_elim"),
    (disj_elim,"safe_elim"),
    (imp_celim,"safe_elim"),
    (iff_elim,"safe_elim") ];


(*Quantifier rules*)
val quant_rulepairs =
  [ (all_intr,"safe_intr"),
    (all_elim,"haz_elim"),
    (exists_intr,"haz_intr"), (exists_cintr,"haz_cintr"),
    (exists_elim,"safe_elim") ];


structure Pc_Rule_tab = 
  struct
    structure Pure = Pure
    val pairs = prop_rulepairs@quant_rulepairs
  end;

structure Pc = ProverFun
	(structure Cla_Lemmas=Cla_Lemmas and Rule_tab=Pc_Rule_tab);
