(*  Title: 	FOL/ex/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Executes all examples for First-Order Logic. 
*)

writeln"Root file for FOL examples";


print_depth 3;  
timing true;

PolyML.use "ex/foundn.ML";
PolyML.use "ex/prolog.ML";

writeln"\n** Intuitionistic examples **\n";
PolyML.use "ex/int.ML";

val thy = Int_Rule.thy  and  tac = pc_tac 1;
PolyML.use "ex/prop.ML";
PolyML.use "ex/quant.ML";

writeln"\n** Classical examples **\n";
PolyML.use "ex/cla.ML";
PolyML.use "ex/if.ML";

val thy = cla_thy  and  tac = fast_tac [] 1;
PolyML.use "ex/prop.ML";
PolyML.use "ex/quant.ML";

writeln"END: Root file for FOL examples";
