(*  Title: 	FOL/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Adds First-Order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory FOL.
*)

writeln"Root file for First-Order Logic";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "int-prover.ML";
use "cla-lemmas.ML";
use "cla-prover.ML";

print_depth 1;  
structure FOL_Syntax = FOL_SyntaxFun(Syntax);
structure Int_Rule = Int_RuleFun
    (structure FOL_Syntax=FOL_Syntax and Pure=Pure);
structure Int_Prover = Int_ProverFun(Int_Rule);
structure Cla_Lemmas = Cla_LemmasFun(Int_Prover);

print_depth 0;  
open Pure FOL_Syntax Int_Rule Int_Prover Cla_Lemmas;

Unify.printer := Syntax.prin syn;

print_depth 1;  
use "pc.ML";
open Pc;

print_depth 8;  
