(*  Title: 	FOL/ruleshell
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Natural Deduction Rules for Intuitionistic first-order logic 

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature INT_RULE =
  sig
  structure FOL_Syntax: FOL_SYNTAX and Pure: PURE
	sharing FOL_Syntax.Syntax = Pure.Sign.Syntax
  val sign: Pure.Sign.sg
  val thy: Pure.theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  val refl: Pure.thm
  val sym: Pure.thm
  val trans: Pure.thm
  val conj_intr: Pure.thm
  val conjunct1: Pure.thm
  val conjunct2: Pure.thm
  val disj_intr1: Pure.thm
  val disj_intr2: Pure.thm
  val disj_elim: Pure.thm
  val imp_intr: Pure.thm
  val mp: Pure.thm
  val False_elim: Pure.thm
  val True_def: Pure.thm
  val not_def: Pure.thm
  val iff_def: Pure.thm
  val all_intr: Pure.thm
  val spec: Pure.thm
  val exists_intr: Pure.thm
  val exists_elim: Pure.thm
  end;


functor Int_RuleFun (structure FOL_Syntax: FOL_SYNTAX and Pure: PURE
	sharing FOL_Syntax.Syntax = Pure.Sign.Syntax) : INT_RULE = 
struct
structure FOL_Syntax = FOL_Syntax;
structure Pure = Pure;
local open Pure 
in

val thy = enrich_theory pure_thy "FOL"
    (["term","form","prop"],  FOL_Syntax.const_decs,  FOL_Syntax.syn) 
[
  (*Equality*)

  ("refl",   "a=a"  ),

  ("sym",  "a=b ==> b=a"  ),

  ("trans",  "[| a=b;  b=c |] ==> a=c"),


  (*Propositional logic*)

  ("conj_intr",  "[| P;  Q |] ==> P&Q"  ),

  ("conjunct1", "P&Q ==> P"),

  ("conjunct2", "P&Q ==> Q"),


  ("disj_intr1",   "P ==> P|Q"  ),

  ("disj_intr2",   "Q ==> P|Q"  ),

  ("disj_elim",    "[| P|Q;  P ==> R;  Q ==> R |] ==> R"),


  ("imp_intr",  "(P ==> Q) ==> P-->Q"),

  ("mp", "[| P-->Q;  P |] ==> Q"),


  ("False_elim",   "False ==> P" ),


  ("True_def",  "True == False-->False"),
  ("not_def", 	"~P == P-->False"),
  ("iff_def",  "P<->Q == (P-->Q) & (Q-->P)"),


  (*Quantifiers*)

  ("all_intr",  "(!y. P(y)) ==> ALL x.P(x)"  ),

  ("spec", "ALL x.P(x) ==> P(a)"),


  ("exists_intr",  "P(a) ==> EX x.P(x)"  ),

  ("exists_elim",  "[| EX x.P(x);  !y.P(y) ==> R |] ==> R")
];

val sign = sign_of thy;

val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
val refl = ax"refl";
val sym = ax"sym";
val trans = ax"trans";
val conj_intr = ax"conj_intr";
val conjunct1 = ax"conjunct1";
val conjunct2 = ax"conjunct2";
val disj_intr1 = ax"disj_intr1";
val disj_intr2 = ax"disj_intr2";
val disj_elim = ax"disj_elim";
val imp_intr = ax"imp_intr";
val mp = ax"mp";
val False_elim = ax"False_elim";
val True_def = ax"True_def";
val not_def = ax"not_def";
val iff_def = ax"iff_def";
val all_intr = ax"all_intr";
val spec = ax"spec";
val exists_intr = ax"exists_intr";
val exists_elim = ax"exists_elim";

end;
end;
