(*  Title: 	CTT/ex/bool
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Derivation of rules for the type Bool, defined as Bool == T+T
*)


(*formation rule*)
val bool_form = prove_goal bool_thy 
    "Bool type"
 (fn prems=>
  [ (rewrite_goals_tac bool_defs),
    (typechk_tac[]) ]);


(*introduction rules for true, false*)

val bool_intr_true = prove_goal bool_thy 
    "true : Bool"
 (fn prems=>
  [ (rewrite_goals_tac bool_defs),
    (typechk_tac[]) ]);

val bool_intr_false = prove_goal bool_thy 
    "false : Bool"
 (fn prems=>
  [ (rewrite_goals_tac bool_defs),
    (typechk_tac[]) ]);


(*Unfolds defs in prems, then passes them to tf. *)
fun rewcomp defs tf prems = tf (map (rewrite_rule defs) prems);


(*elimination rule: typing of cond*)
val bool_elim = prove_goal bool_thy 
    "[| p:Bool;  a : C(true);  b : C(false) |] ==> cond(p,a,b) : C(p)"
 (rewcomp bool_defs  (fn prems=>
  [ (rewrite_goals_tac bool_defs),
    (typechk_tac prems),
    (ALLGOALS (biresolve_tac [ (true,T_elim) ])),
    (typechk_tac prems) ]));


val bool_elim_long = prove_goal bool_thy 
    "[| p = q : Bool;  a = c : C(true);  b = d : C(false) |] ==> cond(p,a,b) = cond(q,c,d) : C(p)"
 (rewcomp bool_defs  (fn prems=>
  [ (rewrite_goals_tac bool_defs),
    (equal_tac prems),
    (ALLGOALS (biresolve_tac [ (true, T_elim_long RES refl_elem) ])),
    (equal_tac prems) ]));


(*computation rules for true, false*)

val bool_comp_true = prove_goal bool_thy 
    "[| a : C(true);  b : C(false) |] ==> cond(true,a,b) = a : C(true)"
 (rewcomp bool_defs  (fn prems=>
  [ (rewrite_goals_tac bool_defs),
    (resolve_tac comp_rls 1),
    (typechk_tac[]),
    (ALLGOALS (biresolve_tac [ (true, T_elim) ])),
    (typechk_tac prems) ]));


val bool_comp_false = prove_goal bool_thy 
    "[| a : C(true);  b : C(false) |] ==> cond(false,a,b) = b : C(false)"
 (rewcomp bool_defs  (fn prems=>
  [ (rewrite_goals_tac bool_defs),
    (resolve_tac comp_rls 1),
    (typechk_tac[]),
    (ALLGOALS (biresolve_tac [ (true, T_elim) ])),
    (typechk_tac prems) ]));


writeln"Reached end of file.";

(*28 August 1988: loaded this file in 9 seconds*)
(*2 September 1988: loaded this file in 10 seconds*)
