(*  Title: 	CTT/arith
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Arithmetic operators and their definitions
*)

(** Syntax **)
local open Syntax
in  val mixfix = 
      [ Infixr("#+",	[Aterm,Aterm]--->Aterm, 25),
        Infixr("-",	[Aterm,Aterm]--->Aterm, 25),
        Infixr("|-|",	[Aterm,Aterm]--->Aterm, 25),
        Infixr("#*",	[Aterm,Aterm]--->Aterm, 35),
        Infixr("'/'/",	[Aterm,Aterm]--->Aterm, 35),
        Infixr("'/",	[Aterm,Aterm]--->Aterm, 35)];

    val arith_ext = {logical_types=[],
     		     mixfix=mixfix,
		     parse_translation=[],
		     print_translation=[]};

    val arith_const_decs = constants mixfix;
    val arith_syn = Syntax.extend CTT_Syntax.syn arith_ext
end;


val arith_thy = enrich_theory CTT_Rule.thy  "arith" 
    ([], arith_const_decs,  arith_syn)

  [ ("add_def",   "a#+b == rec(a, b, %u v.succ(v))"),  
    ("diff_def",  "a-b == rec(b, a, %u v.rec(v, 0, %x y.x))"),  
    ("absdiff_def",  "a|-|b == (a-b) #+ (b-a)"),  
    ("mult_def",  "a#*b == rec(a, 0, %u v. b #+ v)"),  
    ("mod_def",   "a//b == rec(a, 0, %u v.   \
  \			rec(succ(v) |-| b, 0, %x y.succ(v)))"),  
    ("quo_def",   "a/b == rec(a, 0, %u v.   \
  \			rec(succ(u) // b, succ(v), %x y.v))") ];


local val ax = get_axiom arith_thy
in  val add_def = ax"add_def"
    and diff_def = ax"diff_def"
    and absdiff_def = ax"absdiff_def"
    and mult_def = ax"mult_def"
    and mod_def = ax"mod_def"
    and quo_def = ax"quo_def"
end;

val arith_defs = [add_def, diff_def, absdiff_def, mult_def, mod_def, quo_def];

