signature RefSequence =

(* GENERAL POLYMORPHIC VARIABLE SEQUENCES

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        21 Feb 1989

   Maintenance: Author


   DESCRIPTION

   These functions form a general interface for one-dimensional variable
   sequences, such as lists and vectors.

   The design parallels that of the Sequence signature, varying only in
   the presence of imperative type variables and the functions  same
   and  different.

   SEE ALSO

   Object, Sequence, MonoSequence, RefSequenceToObject.
*)

sig

(* TYPES *)

  type 'a T


(* OBSERVERS *)

  val same:  '_a T -> '_a T -> bool
   (* same x y; returns true if x and y are the same RefVector. *)

  val different:  '_a T -> '_a T -> bool
   (* different x y; returns true if x and y are not the same RefVector. *)

  val eq: ('_a -> '_a -> bool) -> '_a T -> '_a T -> bool

  val ne: ('_a -> '_a -> bool) -> '_a T -> '_a T -> bool

  val lt: ('_a -> '_a -> bool) -> '_a T -> '_a T -> bool

  val le: ('_a -> '_a -> bool) -> '_a T -> '_a T -> bool

  val gt: ('_a -> '_a -> bool) -> '_a T -> '_a T -> bool

  val ge: ('_a -> '_a -> bool) -> '_a T -> '_a T -> bool


(* CONVERTORS *)

  val stringSep: string -> string -> string ->
		 ('_a -> string) -> '_a T -> string

  val string: ('_a -> string) -> '_a T -> string

  exception Sep of string * string * string * string

  val parseSepN: string -> string -> string ->
		 (string list -> ('_a * string list, 'b) Result) ->
		 Nat -> string -> ('_a T, '_a T Option) Result

  val parseSep: string -> string -> string ->
                (string list -> ('_a * string list, 'b) Result) ->
                string -> ('_a T, '_a T Option) Result

  val parse: (string list -> ('_a * string list, 'b) Result) ->
             string -> ('_a T, '_a T Option) Result

  val parseN: (string list -> ('_a * string list, 'b) Result) ->
              Nat -> string -> ('_a T, '_a T Option) Result

  val parseSepN': string -> string -> string ->
                 (string list -> ('_a * string list, 'b) Result) ->
                 Nat -> string list ->
                 ('_a T * string list, '_a T Option * string list) Result

  val parseSep': string -> string -> string ->
                 (string list -> ('_a * string list, 'b) Result) ->
                 string list ->
                 ('_a T * string list, '_a T Option * string list) Result

  val parse': (string list -> ('_a * string list, 'b) Result) ->
              string list ->
              ('_a T * string list, '_a T Option * string list) Result

  val parseN': (string list -> ('_a * string list, 'b) Result) ->
               Nat -> string list ->
               ('_a T * string list, '_a T Option * string list) Result

  val readSep: string -> string -> string ->
               (InStream -> ('_a, 'b) Result) -> InStream ->
               ('_a T, '_a T Option) Result

  val readSepN: string -> string -> string ->
               (InStream -> ('_a, 'b) Result) -> Nat -> InStream ->
               ('_a T, '_a T Option) Result

  val read: (InStream -> ('_a, 'b) Result) -> InStream ->
            ('_a T, '_a T Option) Result

  val readN: (InStream -> ('_a, 'b) Result) -> Nat -> InStream ->
             ('_a T, '_a T Option) Result
end
