
signature Bool =
sig

(* BOOLEANS

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance: Author


   DESCRIPTION

   Standard functions on the built-in type "bool".


   NOTES

   Possibly there should be read and write functions for binary form
   as well as ascii.  Portability issues would have to be addresses if
   this were so.
*)

  val version: real
   (* version = 0.1 *)


(* PERVASIVES *)

  val not: bool -> bool


(* OBJECT *)

  structure Object: Object

  type T

  val parse': string list ->
              (bool * string list, bool Option * string list) Result

  val parse:  string -> (bool, bool Option) Result

  val read: InStream -> (bool, bool Option) Result

  val string: bool -> string

  val fixedWidth: bool
   (* fixedWidth = false. *)

  val eq: bool -> bool -> bool

  val ne: bool -> bool -> bool

  val lt: bool -> bool -> bool
   (* lt x y; raises General.NotImplemented "Bool.lt". *)

  val le: bool -> bool -> bool
   (* le x y; raises General.NotImplemented "Bool.le". *)

  val gt: bool -> bool -> bool
   (* gt x y; raises General.NotImplemented "Bool.gt". *)

  val ge: bool -> bool -> bool
   (* ge x y; raises General.NotImplemented "Bool.ge". *)


(* MANIPULATORS *)

  (* infix 1 or *)
  val or: bool * bool -> bool
   (* or (x, y); the standard logic function. *)

  (* infix 2 & *)
  val & : bool * bool -> bool
   (* x & y; the standard logic function. *)

  (* infix 3 implies *)
  val implies : bool * bool -> bool
   (* x implies y; the standard logic function. *)

end
