
structure ByteObject: Object =

(* BYTES

   Created by:	Dave Berry LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance:	Author
*)

struct

  val version = 0.1


(* TYPES *)

  type T = string


(* OBSERVERS *)

  val fixedWidth = true

  fun lt x y = ord x <  ord y
  fun gt x y = ord x >  ord y
  fun le x y = ord x <= ord y
  fun ge x y = ord x >= ord y
  fun eq x y = ord x =  ord y
  fun ne x y = ord x <> ord y


(* CONVERTERS *)

  val string = General.id;

  fun parse' [] = Fail (None, [])
  |   parse' (h::t) = OK (h, t)

  fun read i =
        case InStream.input1 i of
          "" => Fail None
  	| s  => OK s

  fun parse s =
	case parse' (explode s) of
	  OK (l, _) => OK l
        | Fail _ => Fail None
end
