(*$SequenceToObject : Sequence Object *)

functor SequenceToObject (

(* MAKE A MONOVECTOR

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        22 Jan 1990

   Maintenance: Author


   DESCRIPTION

   A functor to make an Object from a Sequence of Objects (where the elements of
   the Sequence have (mono)type T and the resulting Object has type T list.


   NOTES

   This is provided so that one can have MonoVectors of Sequences.

*)

  structure Sequence: Sequence
  structure Object: Object
): Object =
struct

  val version = 0.1


(* TYPES *)

  type T = Object.T Sequence.T


(* CONVERTORS *)

  val read   = Sequence.read Object.read
  val parse' = Sequence.parse' Object.parse'
  val parse  = Sequence.parse Object.parse'
  val string = Sequence.string Object.string


(* OBSERVERS *)

  val fixedWidth = false

  val eq = Sequence.eq Object.eq
  val ne = Sequence.ne Object.ne
  val lt = Sequence.lt Object.lt
  val le = Sequence.le Object.le
  val gt = Sequence.gt Object.gt
  val ge = Sequence.ge Object.ge
end
