
loadSig "OutStream";

structure OutStream: OutStream =

(* OUTPUT STREAMS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        12 Nov 1989

   Maintenance: Author


   SEE ALSO

   InStream, StreamPair
*)

struct

  val version = 0.1


(* TYPES *)

  datatype OutStream = O of outstream * string
   (* The first argument is the built-in outstream, the second is the
      name of the associated file. *)

  type outstream = OutStream


(* MANIPULATORS *)

  val stdOut = O (std_out, "Standard Output")

  val std_out = stdOut

  fun openOut file =
	O (open_out file, file)
	handle Io _ => raise General.Io ("openOut", file, "")

  val open_out = openOut

  fun closeOut (O (os, _)) = close_out os

  val close_out = closeOut

  local
    val out = output
  in
    fun output (O (os, file), s) =
	  out (os, s)
	  handle Io _ => raise General.Io ("output", file, s)
  end

  val output' = General.curry output


(* SYSTEM *)

  exception NotImplemented of string

  fun openAppend s = raise NotImplemented "openAppend"
  fun eof os = raise NotImplemented "eof"
  fun flush os = raise NotImplemented "flush"
  fun interactive os = raise NotImplemented "interactive"

end
