functor YaccToolDefFun (SMLTool :TOOL) :TOOLDEF = struct

val toolName = "yacc"

val targetNamer = ref (fn (pathname:string) => (pathname ^ ".sml"))
val processor = ref "sml-yacc"

fun sigFile (pathname:string) = (pathname ^ ".sig")

fun runYacc (sourceName:string) = 
  let val _ = (print "[starting sml-yacc "; print sourceName; print "]\n")
      val callString = ((!processor)^" "^sourceName)
      val _ = (print ("[" ^ callString ^ "]\n"))
      val status = System.system callString
  in if (status = 0) then ()
       else raise SourceGroup.CompilingError;
   print "[ending   sml-yacc "; print sourceName; print "]\n"
  end

fun fileExists filename =
  let val _ = System.Unsafe.SysIO.mtime (System.Unsafe.SysIO.PATH filename) in
    true
  end handle _ => false

fun loadSource (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  let val sigfile = sigFile sourceName in
    runYacc sourceName;
    SMLTool.loadSource group sigfile (SMLTool.targetNameOf sigfile);
    SMLTool.loadSource group targetName (SMLTool.targetNameOf targetName)
  end

fun genTarget (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  let val sigfile = sigFile sourceName in
    runYacc sourceName;
    SMLTool.genTarget group sigfile (SMLTool.targetNameOf sigfile);
    SMLTool.genTarget group targetName (SMLTool.targetNameOf targetName)
  end

fun loadTarget (group:SourceGroup.group) (sourceName:string) (targetName:string) = 
  let val sigfile = sigFile sourceName in
    SMLTool.checkLoad group sigfile (SMLTool.targetNameOf sigfile);
    SMLTool.checkLoad group targetName (SMLTool.targetNameOf targetName)
  end

fun compileSource (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  let val sigfile = sigFile sourceName in
    runYacc sourceName;
    SMLTool.compileSource group sigfile (SMLTool.targetNameOf sigfile);
    SMLTool.compileSource group targetName (SMLTool.targetNameOf targetName)
  end

fun validTarget (group:SourceGroup.group) (sourceName:string) (targetName:string) = 
  (fileExists targetName) andalso (fileExists (sigFile sourceName))

fun checkLoad (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  if validTarget group sourceName targetName
    then loadTarget group sourceName targetName
    else loadSource group sourceName targetName
end;
