functor ToolInternalsFun
  (structure Data :DATA
   structure Group :GROUP
     sharing Data = Group.Data
   structure Hash :HASH
   structure Hasher :HASHER
   structure Util :UTIL
  ) :TOOL_INTERNALS = struct

structure Data = Data
open Data

datatype toolInfo = Tool of
  {toolName      :string,
   targetNameOf  :string -> string,
   validTarget   :group -> string -> string -> bool,
   loadSource    :group -> string -> string -> unit,
   genTarget     :group -> string -> string -> unit,
   loadTarget    :group -> string -> string -> unit,
   compileSource :group -> string -> string -> unit,
   checkLoad     :group -> string -> string -> unit}

exception Skip
exception SourceGroup'InternalError

val toolTable = Hash.createDefault ([]:toolInfo list)

fun getToolInfo (toolH as (toolName,_)) = Hash.lookup' toolTable toolH

fun toolIsDefined (toolH as (toolName,_)) =
  case  Hash.lookup toolTable toolH of
     NONE => false | (SOME _) => true

fun defineTool (toolInfo:toolInfo as Tool {toolName,...}) =
  Hash.enter toolTable (Hasher.hasher toolName) toolInfo
    
fun updateEnv
      (group:group, sourceName:string, targetName:string, updateSource:bool) =
  let val (F {envUpdateTime,envObjectTime,...}) = 
            Group.findFileThruGroups true Skip
              (Group.findGroup group) (Hasher.hasher sourceName)
  in
    envUpdateTime := Util.currentTime ();
    envObjectTime :=
      Util.modtime (if updateSource then sourceName else targetName)
  end handle Skip => ()

val _ = (Util.toolIsDefined := toolIsDefined)
end
