(* Gene Rollins (rollins@cs.cmu.edu)
   School of Computer Science, Carnegie-Mellon Univ., Pittsburgh, PA 15213 *)

signature SOURCEACTION = sig
  val withOutputFile   :string -> (outstream -> unit) -> unit
  val doLoadSource     :SourceGroup.sourceInfo -> unit
  val doCompile        :SourceGroup.sourceInfo -> unit
  val doClean          :SourceGroup.sourceInfo -> unit
  val doNothing        :SourceGroup.sourceInfo -> unit
  val doLoadLibrary    :SourceGroup.sourceInfo -> unit
  val standardBinary   :string -> string
  val importBinary     :string -> string
  val systemBinary     :string -> string -> string
  val sysBinary        :string -> string
  val showUses         :SourceGroup.group -> outstream -> unit
  val showDependencies :SourceGroup.group -> outstream -> unit

  type actionTable
  val actionTable      :unit -> actionTable
  val clearAction      :actionTable -> string -> unit
  val doAction         :actionTable -> (SourceGroup.sourceInfo->unit) -> 
                          SourceGroup.sourceInfo -> unit
  val updateAction     :actionTable -> string ->
                          (SourceGroup.sourceInfo->unit) -> unit
end
