module -- remzf
#include "../expr/types.t.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/pprint.t"
#include "../misc/misc.t"
#include "../transform/hexpr.t"
#include "../transform/exprs.t"
#include "../misc/flags.t"
export remzf;
rec remzf e u = if Curry then rz e u else (e, u)
and rz e u =
	case e in
	   mkap f a :
		let (f1, u1) = rz f u in
		let (a1, u2) = rz a u1 in
		(mkap f1 a1, u2)
	|| mklam i e :	Uap (\e1.mklam i e1) (rz e u)
	|| mkcase e pl :
		let (e1, u1) = rz e u in
		let (pl1, u2) = Umap (\(p, e).\u.
			let (np, u1) = rzp p u in
			let (ne, u2) = rz e u1 in
			(np, ne),u2) pl u1 in
		(mkcase e1 pl1, u2)
	|| mkletv b e :
		let (b1, u1) = rzb b u in
		let (e1, u2) = rz e u1 in
		(mkletv b1 e1, u2)
	|| mkident _ : (e, u)
	|| mkmodule i fs is es b : Uap (mkmodule i fs is es) (rzb b u)
	|| mkerror _ : (e, u)
	|| mkconstr c el : Uap (mkconstr c) (Umap rz el u)
	|| mkconst _ : (e, u)
	|| mkinfo t e : Uap (mkinfo t) (rz e u)
	|| mklistg e qs :
		let (e', u') = L e qs enil u in
		rz e' u'
	|| e : fail ("No match in rz: "@ppr e)
	end
and
    rzb b u =
	case b in
	   mkband b1 b2 :
		let (b11, u1) = rzb b1 u in
		let (b21, u2) = rzb b2 u1 in
		(mkband b11 b21, u2)
	|| mkbrec b : Uap mkbrec (rzb b u)
        || mkbmulti p e :
	       let (p', u') = rzp p u in
	       let (e', u'') = rz e u' in
	       (mkbmulti p' e', u'')
	|| mkbpat pes : 
	       let (pes', u') = Umap (\(p, e).\u.
			let (np, u1) = rzp p u in
			let (ne, u2) = rz e u1 in
			(np, ne),u2) pes u
	       in (mkbpat pes', u')
	|| mkberror _ : (b, u)
	|| mkbnull : (b, u)
	|| mkblocal b1 b2 :
		let (b11, u1) = rzb b1 u in
		let (b21, u2) = rzb b2 u1 in
		(mkblocal b11 b21, u2)
	|| mkbtype _ _ _ : (b, u)
	|| mkbclass t b : Uap (mkbclass t) (rzb b u)
	|| mkbinstance t b oi : Uap (\b.mkbinstance t b oi) (rzb b u)
	|| mkbsign _ _ : (b, u)
	|| mkbdefault _ : (b, u)
        || _ : fail ("rzb "@prdefg 0 b)
	end
and rzp (mkcondp p c) u =
	let (nc, u1) = rz c u in (mkcondp p nc, u1)
||  rzp p u = (p, u)

and eif b t f = mkcase b [(mkident hitrue, t); (mkident hifalse, f)]
and econs e1 e2 = mkap (mkap (mkident hicons) e1) e2
and enil = mkident hinil
and elet i e1 e2 = mkletv (mkbrec (mkbpat [(i, e1)])) e2
and eap e1 e2 = mkap e1 e2
and edum = mkident dummyid
and etrue = mkident hitrue
and canfail (mkident _) = false
||  canfail (mkas _ p) = canfail p
||  canfail _ = true
and
    L e [] t u =
	(econs e t, u)
||  L e (mkqfilter f.r) t u =
	let (q, u') = L e r t u
	in (eif f q t, u')
-- It seems to be an idiom to write [ x | p<-[e]], so handle that specially
||  L e (mkqgen p (mkap (mkap (mkident ic) es) (mkident ini)).r) t u & (eqid ic hicons & eqid ini hinil) =
	let (e', u') = L e r t u in
        case p in
	    mkident _ : (mkletv (mkbpat [(p, es)]) e', u')
        ||  _ : (mkcase es ((p, e'). (if canfail p then [(edum, t)] else [])), u')
        end
||  L e (mkqgen p l.r) t u =
	let g = newid u
	and xs = newid (u+1)
	in let (q, u') = L e r (eap g xs) (u+2)
	in (elet g (Lg g p t q xs u') (eap g l), u'+1)
and Lg g p t q xs u =
	let a = newid u in
	let dum = (econs edum xs, eap g xs)
	and pat = econs p xs in
	let d =
	        if canfail p then
		    [(pat, q); dum]
		else
		    [(pat, q)]
/*
		case p in
		   mkcondp _ _ : [(pat, q); dum]
		|| mkident _ : [(pat, q)]
		|| _ : [(mkcondp pat etrue, q); dum]
		end
*/
	in
	mklam a (mkcase a ((enil, t) . d))
end
