module -- check
--
-- $Header: /ufs/usr.src/local/lml/src/type/RCS/check.m,v 97.0 90/07/07 14:42:39 augustss Exp $
--
-- performs the actual type checking
--
-- The strictification (with let!) is a very small improvement,
-- but since I put it in it can stay...
--
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/einfo.t.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/id.t"
#include "../expr/constrfun.t"
#include "../Expr/Expr.t.t"
#include "../Expr/Eprint.t"
#include "../Expr/Egetid.t"
#include "../Expr/unrec.t"
#include "../transform/misc.t"
#include "subst.t.t"
#include "prefix.t"
#include "subst.t"
#include "unify.t"

export Wdll, echk, combTRs, ecombTRs, ecombTR;

rec Wdll p b u = let (S, np, t) = Wdl p (conc b) u in (S, np, t, b)
and echk f (bad [s]) = bad [' '.pr f; s]
||  echk _ t = t
and combTRs [S] = S
||  combTRs Ss = reduce combTR emptyTR Ss
and ecombTR f s1 s2 = echk f (combTR s1 s2)
and ecombTRs f Ss = echk f (combTRs Ss)
and cst ((c, _ ,_)._) = ctype c
and consinst c u = instTR (getTvars (cst c)) u
and addterr i (bad es) = bad (idtostr i.es)
||  addterr _ S = S
and
    chkdefs p u ds =
	let! (u1, STs) =
		mapstate (\u.\(a,b).let! (R,r,u1)=W p b u 
				    in (u1,(addterr a R,r))) u ds
	in
	let! (Ss, Ts) = split STs in
	(u1, combTRs Ss, Ts)
and
    Wdlnorm p dl u =
	let! (u1, R, ts) = chkdefs p u dl in
	let pre = combine (map fst dl, map (TRtype R) ts)
	and p1 = TRprefix R p in
	(R, addpre pre p1, u1)
and
    Wdlrec p dl u =
	let ul = u+length dl in
	let nt = for u (ul-1) mktvar in
	let! (u1, R, dTs) = chkdefs (addngs (combine (map fst dl, nt)) p) ul dl in
	let Ss = map (\(dT, T).Unify T dT) (combine (dTs, nt)) in
	let R = combTR (combTRs Ss) R in
	let pre = combine (map fst dl, map (TRtype R) dTs)
	and p1 = TRprefix R p in
	(R, addpre pre p1, u1)
and
    W p f u =
	case f in
	   Einfo (restr t) e :
		let! (R, r, u1) = W p e u in
		let! (tn, u2) = inst t (getTvars t) u1 in
		let U = Unify r tn in
		let V = ecombTR f R U in
		-- check that restr. are not inst.
		let V1 = chkgen (count u1 (u2-1)) V r tn [] in
		(pruneTR u V1, TRtype V1 r, u2)
	|| Einfo (trestr t) e :
		let! (R, r, u1) = W p e u in
		let U = Unify r t in
		let V = ecombTR f R U in
		(pruneTR u V, TRtype V r, u1)
	|| Einfo notchk e :				-- No typecheck here, assume a fresh variable
	        (emptyTR, mktvar u, u+1)
	|| Einfo f e :
		let! (R, r, u1) = W p e u in
		(R, r, u1)
	|| Eap d e :
		let! (R, r, u1) = W p d u in
		let! (S, s, u2) = W p e u1 in
		let beta = mktvar u2 in
		let U = Unify r (Tarr s beta) in
		let V = ecombTR f U (combTR S R) in
		(pruneTR u V, TRtype V beta, u2+1)
	|| Evar i :
		let! (typ, gl) = pfind i p in
		let! (t, un) = inst typ gl u in
		(emptyTR, t, un)
	|| Econstr (Cconstr _ ctyp _ _ ts) es :
		let! (T, u1) = instTR (getTvars ctyp) u in
		let! (u2, Ss) =
		    mapstate (\u.\(t,e).let (R, r, u1) = W p e u in
					(u1, ecombTR e (Unify r (T t)) R))
			     u1
			     (combine (map fst ts, es))
		in
		let R = ecombTRs f Ss in
		(pruneTR u R, TRtype R (T ctyp), u2)
	|| Elam i d :
		let tv = mktvar u in
		let! (R, r, u1) = W (addngens [(i, (tv, []))] p) d (u+1) in
		(pruneTR u R, TRtype R (Tarr tv r), u1)
	|| Efailmatch _ :
		(emptyTR, mktvar u, u+1)
	|| Ecase e ces de :
		-- T is used to instanciate the typevars for the constructor
		let! (T, u1) = consinst ces u in
		let! (R0, eT, u2) = W p e u1 in
		let R1 = Unify (T (cst ces)) eT in
		let! (R2, ResT, u3) = W p de u2 in
		let! (u4, Ts) =
	mapstate (\u.\((Cconstr _ _ _ _ ts), is, e).
	    let! (V, r, u1) = W (addngs (combine(is, map (T o fst) ts)) p) e u in
	    let U = Unify ResT r in
	    (u1, ecombTR e U V))
	u3
	ces
		in
		let S = ecombTRs f (Ts@[R2;R1;R0]) in
		(pruneTR u S, TRtype S ResT, u4)

	|| Elet r dl exp :
		let! (R, pref, u1) = if r then Wdlrec p dl u
				         else Wdlnorm p dl u in
		let! (S, s, u2) = W pref exp u1 in
		(pruneTR u (ecombTR f S R), s, u2)
	end

and Wdl pre dl u = f emptyTR pre u (sccds dl)
    where rec f T p u [] = (T, p, u)
           || f T p u ((r, ds as (_,e)._).dss) =
	let! (R, p', u') = if r then Wdlrec p ds u else Wdlnorm p ds u in
	f (ecombTR e T R) p' u' dss
end
