module -- remsign
#include "../expr/id.t"
#include "../expr/id.t.t"
#include "../expr/types.t.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/einfo.t.t"
#include "../expr/pprint.t"
#include "../rename/renameutil.t"
#include "../misc/util.t"
#include "../misc/misc.t"
#include "../misc/flags.t"
#include "../type/conutil.t"		-- himplies
#include "lettrans.t"
#include "hexpr.t"

-- Remove type signatures and type synonymes
-- Also check context implication for all types.

export remsign;
rec remsign e = rstop e -- do this even for LML to remove mkbsyn
and rstop (e as mkmodule i fl il el b) =
    case getdefs b in
	[] : (rs e, [mktcons hiInt []; mktcons hiDouble []])
    ||  [mkbdefault ts] : case partition okdef (map synexpandall ts) in
	                      (ts, []) : (rs e, ts)
                          ||  (_, ts) : (mkerror ("Bad defaults: "@mix (map prttype ts) ", "), [])
			  end
    ||  _ : (mkerror "More than one default", [])
    end

-- Check if t is an instance of c by looking for c in t's instances
and tisinstance c (mkid _ _ (idi_type _ _ _ is _) _) = findf is (\t.eqid c (iclsname t)) (\x.true) false

-- Is this enough?
and okdef (t as mktcons ti _) = tisinstance hiNum ti & getTvars t = []
||  okdef _ = false
and getdefs (mkbrec b) = getdefs b
||  getdefs (mkband b1 b2) = getdefs b1 @ getdefs b2
||  getdefs (d as mkbdefault ts) = [d]
||  getdefs (mkblocal _ b) = getdefs b
||  getdefs _ = []
and    
    rs t =
	case t in
	   (mkap f a) :  mkap (rs f) (rs a)
	|| (mklam e1 e) : mklam e1 (rs e)
	|| (mkcase e cl) : mkcase (rs e) (map rsp cl)
	|| (mkletv b e) : mkletv (rsb b) (rs e)
	|| (mkident i) : t
	|| (mkmodule i fl il el b) : mkmodule i fl il el (rsb b)
	|| (mkconst _) : t
--	|| (mkas i p) : mkas i (rs p)
	|| (mkconstr c el) : mkconstr c (map rs el)
--	|| (mkcondp p c) : mkcondp (rs p) (rs c)
--	|| (mklazyp p) : mklazyp (rs p)
        || (mkinfo (f as restr t) e) :
		case typemsg (cpart t) (tpart t) in
		    [] : mkinfo f (rs e)
	        ||  ss : mkerror ("Bad restriction: "@mix ss ", ")
		end
	|| (mkinfo f e) : mkinfo f (rs e)
	|| (mklistg e qs) : mklistg (rs e) (map rsq qs)
	|| (mkerror _) : t
	|| (mkfailmatch _) : t
        || _ : fail ("No match in rs (remsign) "@ppr t)
	end
and rsq (mkqfilter e) = mkqfilter (rs e)
||  rsq (mkqgen p e) = mkqgen (rspp p) (rs e)
and rspp (mkcondp p c) =
	mkcondp p (rspp c)
||  rspp p = p
and
    rsb d =
	case d in
	   (mkbrec b) : mkbrec (rsb b)
	|| (mkband b1 b2) : rems d
	|| (mkblocal b1 b2) : mkblocal (rsb b1) (rsb b2)
	|| (mkbpat pl) : mkbpat (map rsp pl)
	|| (mkbmulti p e) : let (np,ne) = rsp (p,e) in mkbmulti np ne
	|| (mkbsyn src dst) : 
		case typemsg (cpart src) dst in
		    [] : mkbnull
		||  ss : mkberror ("Bad synonym: "@mix ss ", ")
		end
        || (mkbinstance (t as mkidecl aas ci ti vs) b x) : 
		case typemsg aas (mktcons ti (map mktvar vs)) in
		    [] : mkbinstance t (rsb b) x
		||  ss : mkberror ("Bad instance: "@mix ss ", ")
		end
	|| (mkbdefault _) : mkbnull
	|| (mkbtype t cs _) :
		case concmap (\(mkcons _ tbs).concmap (typemsg (cpart t) o fst) tbs) cs in
		    [] : d
		||  ss : mkberror ("Bad type def: "@mix ss ", ")
		end
        || (mkbclass cd b) : mkbclass cd (rsc b)
        || _ : d
	end
and
    rsc (mkbrec b) = mkbrec (rsc b)
||  rsc (mkband b1 b2) = mkband (rsc b1) (rsc b2)
||  rsc (mkbpat pl) = mkbpat (map rsp pl)
||  rsc b = b
and
    rsp (p, e) = (rspp p, rs e)
and
    rems d =
	let (ss, bs') = partition issign (listify d) in
        let sts = concmap flat ss in
	let dis = concmap getdi bs' in
        let sis = map fst sts in
	if anysameeq eqid (map fst sts) then
	    mkberror ("Multiple signatures in "@mix (map oprid sis) ",")
	else if diffeq eqid sis dis ~= [] then
	    mkberror ("Id not in scope for signature "@mix (map oprid sis) ",")
	else
	    andify (map (rsb o subsign sis sts) bs')
and issign (mkbsign _ _) = true
||  issign _ = false
and flat (mkbsign is t) = map (\i.(i, t)) is
and getdi (mkbpat [(mkident i, _)]) = [i]
||  getdi _ = []
and subsign sis sts (mkbpat [(mkident i, e)]) & (member eqid i sis) = mkbpat [(mkident i, mkrestr e (assocdefeq eqid i sts (fail "subsign")))]
||  subsign _ _ b = b
and mkrestr e t = mkinfo (restr t) e

-- Check if all types are implied properly
and typemsg k ot =
    if ~Curry then
	[]
    else
	(tmsg ot
         where rec tmsg (mktcons (mkid _ _ (idi_syn t _ _) _) ts) = chkimp (cpart t) (tpart t) ts @ concmap tmsg ts
	       ||  tmsg (mktcons (mkid _ _ (idi_type t _ _ _ _) _) ts) = chkimp (cpart t) (tpart t) ts @ concmap tmsg ts
	       ||  tmsg _ = []
	 and       /*chkimp [] _ _ = []			-- fast special case
               ||  */chkimp c (t as mktcons ti vs) ts =
		       let al = map2 (\(mktvar v).\t.(v, t)) vs ts in
		       let c' = map (\(mkassert ci v).(ci, assocdef v al (mktvar v))) c in
		       if all (himplies k) c' then
			   []
		       else
			   ["context not implied "@prttype ot@" ("@show_list (\(ci,t). prid ci@" ("@prttype t@")") c'@" by "@prk k@")"]
	 )
and prk c = show_list (\(mkassert ci v).prid ci@" a"@itos v) c
end
