#include "include.h"
#include "lml.h"
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#define MAXINFIX 200
#define MAXISTR 5000

#define COMM 10000
#define PLCOMM 10001

extern id installid();
extern int interactive;
extern double atof();
extern char *malloc();

int lasttoken;
int yylineno = 1;
extern int zyzflag;
char *filename;
FILE *yyin = stdin;
FILE *oldfiles[100];
static char yybuf[5120];
int oldindex = 0;
static int pushtoken = -1;
static int forcedeof = 0;
static char *yyp;
static char tmpname[200] = "";
static char incdir[1024];
char yytext[512];
static int saved = 0;
static char savechar[1024];
#define LASTMAX 10
static int curchar='\n', lastvec[LASTMAX];
static int lastind = 0;
#define lastchar lastvec[lastind % LASTMAX]

static struct yytable {
    char *name;
    short token;
} yytable[] = {
    "let",	LET,
#ifdef OBSOLETE
    "letrec",	LETREC,
#endif /* OBSOLETE */
    "where",	WHERE,
#ifdef OBSOLETE
    "whererec",	WHEREREC,
#endif /* OBSOLETE */
    "in",	IN,
    "rec",	REC,
    "type",	TYPE,
    "and",	AND,
    "if",	IF,
    "then",	THEN,
    "else",	ELSE,
    "module",	MODULE,
    "end",	END,
    "import",	IMPORT,
    "export",	EXPORT,
    "case",	CASE,
    "as",	AS,
    "local",	LOCAL,
    "o",	FCOMP,
    "infix",	MINFIX,
    "infixl",	MINFIX,
    "infixr",	MINFIXR,
    "prefix",	MPREFIX,
    "postfix",	MPOSTFIX,
    "nonfix",	MNONFIX,
    "load",	LOAD,
    "source",	SOURCE,
    "quit",	THEEND,
    0,0,0
};

#define COMM 10000
static struct infix {
    char *iname;	/* first char is ignored */
    short ilen;
    short itoken;
} infixtab[MAXINFIX] = {
"?--",	2,	COMM,
"?/*",	2,	PLCOMM,
"?||",	2,	GUARD,
"?;;",	2,	SUCH,
"?<-",	2,	RARROW,
"?..",	2,	DOTDOT,
"_~=",	2,	NE,
"_>=",	2,	GE,
"_<=",	2,	LE,
"P->",	2,	TFUN,
"_??",	2,	LINDEX,
"_+.",	2,	FPLUS,
"_-.",	2,	FMINUS,
"_*.",	2,	FTIMES,
"_/.",	2,	FDIV,
"_+#",	2,	IPLUS,
"_-#",	2,	IMINUS,
"_*#",	2,	ITIMES,
"_/#",	2,	IDIV,
"_%#",	2,	IMOD,

"?\\",	1,	LAMBDA,
"_.",	1,	DOT,
"?;",	1,	SEMI,
"P,",	1,	COMMA,
"_=",	1,	EQ,
"_>",	1,	GT,
"_<",	1,	LT,
"_+",	1,	PLUS,
"_-",	1,	MINUS,
"_*",	1,	TIMES,
"_/",	1,	DIV,
"_%",	1,	MOD,
"_~",	1,	NOT,
"_&",	1,	ANDOP,
"_|",	1,	OROP,
"?:",	1,	COLON,
"_@",	1,	CONC,
"?(",	1,	LPAR,
"?)",	1,	RPAR,
"?[",	1,	LBRACK,
"?]",	1,	RBRACK,
/*"?{",	1,	LBRACE,*/
"?}",	1,	RBRACE,
"?!",	1,	EXCL,
"_?",	1,	INDEX,
"_^",	1,	RAISE,

"?",	0,	0,

0,	0,	0,
};
static int ninfix;
static char infixstr[MAXISTR];
static char *infixp = infixstr;
#define mlinf (infixtab[0].ilen)	/* longest length */

nfixes()
{
    return ninfix;
}

char *
fixop(n)
{
    return infixtab[n].iname;
}

int
fixtype(n)
{
    switch(infixtab[n].itoken) {
    case INFIXL : return 1;
    case INFIXR : return 2;
    case PREFIX : return 3;
    case NONFIX : return 5;
    case POSTFIX : return 4;
    default : return -1;
    }
}

static
processbackslash(q, p)
register char *p, *q;
{
    register int c;

    while(*p) {
	if ((c = *p++) == '\\') {
	    switch(c = *p++) {
	    case 'n': c = '\n'; break;
	    case 't': c = '\t'; break;
	    case 'r': c = '\r'; break;
	    case 'b': c = '\b'; break;
	    case 'f': c = '\f'; break;
	    case 'e': c = '\033'; break;
	    case '0': case '1': case '2': case '3':
	    case '4': case '5': case '6': case '7':
		c -= '0';
		if ('0' <= *p && *p <= '7')
		    c = c*8 + *p++-'0';
		if ('0' <= *p && *p <= '7')
		    c = c*8 + *p++-'0';
		break;
	    }
	}
	*q++ = c;
    }
    *q = 0;
}


makeinfix(ss, token)
char *ss;
{
    register int i, l;
    char s[1000], *p;

    p = s;
    if (!zyzflag)
	*p++ = '_';
    strcpy(p, ss);
    l = strlen(s);
    if (ninfix >= MAXINFIX || infixp+l+1 >= &infixstr[MAXISTR]) {
	error("Too many infixes.");
	return;
    }
    for(i = ninfix; i > 0; i--) {
	if (infixtab[i-1].ilen >= l)
	    break;
	infixtab[i] = infixtab[i-1];
    }
    infixtab[i].iname = infixp;
    strcpy(infixp, s);
    infixp += l+1;
    infixtab[i].itoken = token;
    infixtab[i].ilen = l-1;
    ninfix++;
/*printf("new fix '%s' %d %d\n", infixtab[i].iname, infixtab[i].ilen, infixtab[i].itoken);*/
}

yyinit()
{
    for(ninfix = 0; infixtab[ninfix].iname; ninfix++)
	;
    saved = 0;
    yylineno = 1;
}

static struct yytable *
lookup(name)
char *name;
{
    register struct yytable *p;

    for(p = yytable; p->name; p++)
	if (strcmp(name, p->name) == 0)
	    return p;
    return 0;
}

static
digit(c)
{
    return '0' <= c && c <= '9';
}

static
letter(c)
register c;
{
    return  'a' <= c && c <= 'z' ||
            'A' <= c && c <= 'Z' ||
	    '0' <= c && c <= '9' ||
	    c == '_' || c == '\'' || (zyzflag && c == '#');
}

static
yygetc()
{
    int c;

    lastvec[++lastind % LASTMAX] = curchar;
    if (saved > 0) {
	c = savechar[--saved];
    } else {
	c = getc(yyin);
    }
    if (c == '\n')
	yylineno++;
    if (c != EOF) {
	*yyp++ = c;
    }
    curchar = c;
    return c;
}

static
yyunget(c)
{
    if (c != EOF) {
	savechar[saved++] = c;
	if (c == '\n')
	    yylineno--;
	yyp--;
	curchar = lastvec[lastind-- % LASTMAX];
    }
}

static
yypeek()
{
    register int c;

    c = yygetc();
    yyunget(c);
    return c;
}

static
gobble(c)
register c;
{
    register int d;

    d = yygetc();
    if (d != c) {
	yyunget(d);
	return 0;
    } else {
	return 1;
    }
}

static
skipdigits()
{
    register int c;

    do {
	c = yygetc();
    } while('0' <= c && c <= '9');
    yyunget(c);
}

static
yylex1()
{
    register int i, j, c;
    int c1;
    register struct yytable *p;
    int t;
    unsigned char ibuff[100];

    if (pushtoken >= 0) {
	t = pushtoken;
	pushtoken = -1;
	return t;
    }
    if (forcedeof)
	return EOF;
    for (;;) {
    again:
	yyp = yytext;
    	/* first try for an infix operator */
	for(i = 0; i < mlinf && yypeek() != '\n' && yypeek() != EOF; i++) {
	    ibuff[i] = yygetc();
	}
	ibuff[i] = 0;
	for(j = 0; j < ninfix; j++) {
	    while (infixtab[j].ilen < i) {
	        yyunget(ibuff[--i]);
		ibuff[i] = 0;
	    }
	    if (i == 0)
	    	break;
	    if (strcmp(ibuff, infixtab[j].iname+1) == 0) {
	    	t = infixtab[j].itoken;
		if (t == COMM) {
		    /* Skip the comment */
		    while ((c = yygetc()) != '\n' && c != EOF)
		        ;
		    yyunget(c);
		    goto again;
		} else if (t == PLCOMM) {
		    do {
			while((c = yygetc()) != '*' && c != EOF)
			    yyp = yytext;
		    } while (yypeek() != '/' && yypeek() != EOF);
		    (void)yygetc();
		    goto again;
		} else {
		    yylval.uid = infixtab[j].iname;
		    return t;
		}
	    }
	}
	c = yygetc();
	switch (c) {
	case EOF: 
	    if (oldindex) {
		popfile();
		return LEOF;
	    } else
		if (interactive) {
		    interactive = 0;
		    return THEEND;
		} else
		    return EOF;
	case '\n': 
	    if (lasttoken != SEMI && interactive && !oldindex)
		secprompt();
	case ' ': 
	case '\t': 
	    break;
	case '{':
	    c = yypeek();
	    for(;;) {
		switch(yygetc()) {
		case '}':
		    *--yyp = 0;
		    yylval.uid = installid(yytext+1);
		    return ANNOT;
		case '\\':
		    if (yygetc() == '\n')
			yyp--;
		    break;
		case '\n':
		case EOF:
		    return SYNTAX_ERROR;
		}
	    }

	hash:
	case '#':
	    if (lastchar == '\n') {
		while((c = yygetc()) != '\n' && c != EOF)
		    ;
		*yyp = 0;
		if (filename)
		    free(filename);
		filename = malloc(1000);
		sscanf(&yytext[1], "%d \"%[^\"]", &yylineno, filename);
	    } else if (isdigit(yypeek())) {
		while(isdigit(yypeek()))
		    (void)yygetc();
		*yyp = 0;
		goto identi;
	    } else {
		return TPAIR;
	    }
	    break;
	case '\'':
	    switch(c = yygetc()) {
	    case '\\':
		switch(c = yygetc()) {
		case 'n': c = '\n'; break;
		case 't': c = '\t'; break;
		case 'r': c = '\r'; break;
		case 'b': c = '\b'; break;
		case 'f': c = '\f'; break;
		case 'e': c = '\033'; break;
		case '0': case '1': case '2': case '3':
		case '4': case '5': case '6': case '7':
		    c -= '0';
		    if ('0' <= yypeek() && yypeek() <= '7')
			c = c*8 + yygetc()-'0';
		    if ('0' <= yypeek() && yypeek() <= '7')
			c = c*8 + yygetc()-'0';
		    break;
		}
	    default:
		yytext[0] = c;
		yytext[1] = 0;
		yylval.uid = installid(yytext); 
		break;
	    }
	    if (gobble('\''))
		return CHAR;
	    else
		return SYNTAX_ERROR;
	case '"':
	    do {
		c = yygetc();
		if (c == EOF || c == '\n')
		    yyerror("Nonterminated string");
		if (c == '\\')
		    if (yygetc() == EOF)
			yyerror("Bad escape char");
	    } while (c != '\"');
	    *--yyp = 0;
	    processbackslash(yybuf, yytext+1);
	    /* Change all tabs back to \t */
	    { char *p, *q;
	      for(q = yybuf, p = yytext; *q; p++, q++) {
		  if ((*p = *q) == '\t')
		      *p++ = '\\', *p = 't';
	      }
	      *p = 0;
	    }
	    yylval.uid = installid(yytext);
	    return STRING;

	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	    skipdigits();
	    c = yygetc();
	    c1 = yypeek();
	    yyunget(c);
	    if (c == '.' && digit(c1) || c == 'e' || c == 'E') {
		if (c == '.') {
		    (void)yygetc();
		    skipdigits();
		    c = yypeek();
		}
		if (c == 'e' || c == 'E') {
		    (void)yygetc();
		    c = yypeek();
		    if (c == '-' || c == '+')
			(void)yygetc();
		    skipdigits();
		}
		*yyp = 0;
		yylval.ufloat = atof(yytext);
		return FLOATCONST;
	    } else if (c == 'I' || c == '#') {
		/* A bignum */
		(void)yygetc();
		*yyp = 0;
		yyp[-1] = 'I';
		yylval.uid = installid(yytext);
		return INTEGERCONST;
	    } else {
		*yyp = 0;
		yylval.uint = atoi(yytext);
		return INTCONST;
	    }
	case '_':
	    if (yypeek() == '#') {
		(void)yygetc();
		goto hash;
	    }
	    /* fall into */
	case '$':
	    if (!letter(yypeek())) {
		*yyp = 0;
		yylval.uid = "_";
		return WILD;
	    }
	default:
	    if (letter(c)) {
		do {
		    c = yygetc();
		} while(c != EOF && letter(c));
		yyunget(c);
		*yyp = 0;
		if (p = lookup(yytext)) {
#if 1
		    if (p->token == LETREC || p->token == WHEREREC)
			obsolete(yytext);
#endif
		    if (!interactive && p->token >= LOAD)
			goto identi;
		    if (p->token == FCOMP)
			yylval.uid = "_o";
		    return p->token;
		} else {
		    char tt[1000];
		identi:
#ifdef OBSOLETE
		    if (strcmp(yytext,"int" )==0 || strcmp(yytext,"bool")==0 ||
			strcmp(yytext,"char")==0 || strcmp(yytext,"list")==0) {
			obsolete(yytext);
			yytext[0] = toupper(yytext[0]);
		    }
#endif
		    sprintf(tt, "%s%s", zyzflag ? "" : "_", yytext);
		    yylval.uid = installid(tt);
		    return ID;
		}
	    } else {
		return SYNTAX_ERROR;
	    }
	}
    }
}

yylex()
{
	register int r;

	yyp = yytext;
	r = yylex1();
	*yyp = 0;
	lasttoken = r;
/*printf("tok=%d(\"%s\"), ", r, yytext);*/
	return r;
}

char loadname[1024];

pushfile(f, s)
FILE *f;
{
    oldfiles[oldindex++] = yyin;
    yyin = f;
}

popfile()
{
    if (*tmpname) {
	unlink(tmpname);
	tmpname[0] = 0;
    }
    fclose(yyin);
    yyin = oldfiles[--oldindex];
}

switchto(s)
{
    FILE *f;
    int l;

    strcpy(loadname, s);
    l = strlen(loadname);
    if (loadname[l-2] == '.') {
	switch(loadname[l-1]) {
	case 'm':
	loadm:
	    if ((f = fopen(loadname, "r")) == NULL) {
		errmsg("Cannot open %s\n", loadname);
		pushtoken = LEOF;
	    } else {
		/* to simple, sigh! pushfile(f); */
		char buf[1024];
		sprintf(tmpname, "/tmp/ilml%d", getpid());
		sprintf(buf, "/lib/cpp -C -I%s %s %s", incdir, loadname, tmpname);
		system(buf);
		fclose(f);
		pushfile(fopen(tmpname, "r"), loadname);
		pushtoken = MLOAD;
	    }
	    break;
	case 'o':
	loado:
	    if ((f = fopen(loadname, "r")) == NULL) {
		errmsg("Cannot open %s\n", loadname);
		pushtoken = LEOF;
	    } else {
		fclose(f);
		loadname[l-1] = 't';
		if ((f = fopen(loadname, "r")) == NULL) {
		    errmsg("Cannot open %s\n", loadname);
		    pushtoken = LEOF;
		} else {
		    loadname[l-1] = 'o';
		    pushfile(f, loadname);
		    pushtoken = OLOAD;
		}
	    }
	    break;
	    
	default:
	    error("Bad file name %s\n", loadname);
	    pushtoken = LEOF;
	}
    } else {
	struct stat sm, so;
	int rm, ro;

	strcpy(loadname+l, ".m");
	l += 2;
	rm = stat(loadname, &sm);
	loadname[l-1] = 'o';
	ro = stat(loadname, &so);
	if (ro == -1 || (unsigned long)sm.st_mtime > so.st_mtime) {
	    loadname[l-1] = 'm';
	    errmsg("Loading %s\n", loadname);
	    goto loadm;
	} else {
	    errmsg("Loading %s\n", loadname);
	    goto loado;
	}
    }
}

source(s)
char *s;
{
    char b[1024];
    FILE *f;

    strcpy(b, s);
    if ((f = fopen(b, "r")) == NULL) {
	errmsg("Cannot open %s\n", loadname);
    } else {
	pushfile(f, s);
    }
}

seteof()
{
    forcedeof = 1;
}

initlex()
{
    char *s;
    extern char *getenv();

    yyinit();
    s = getenv("LMLDIR");
    if (!s) {
	s = "/usr/local/lib/lmlc";
    }
    sprintf(incdir, "%s/lib/include", s);
}

pushextra(t)
{
    pushtoken = t;
}

syntaxerror()
{
    pushtoken = SYNTAX_ERROR;
}

makefixop() {}
