module -- make the program strict
-- Semistrict still allows letrec for data and lazy input because it evals.
-- Strict is completely strict and cannot be mixed with lazy code.
#include "../misc/flags.t"
#include "../expr/einfo.t.t"
#include "../Expr/Expr.t.t"
#include "../misc/misc.t"
#include "../expr/id.t"
export mkstrict;
rec
    ms (e as Einfo strict _) = e
||  ms e = Einfo strict e
and
    mks (Ecase e pl dp) =
	Einfo strict
	      (Ecase (mks e)
		    (map (\(c,il,e).(c, il, mks e)) pl) (mks dp))
 || mks (Elet r dl e) =
	(Elet r (map f dl) (mks e)
	where rec f (i, Elamapl is e es) =
		    (i, Elamapl is (mks e) (map mks es))
	       || f (i, e) = if r & Semistrict then (i, e) else (i, mks e))
 || mks (Econstr c el) = Econstr c (map mks el)
 || mks (Efailmatch n) = Efailmatch n
 || mks (Eidapl i []) =
	if Semistrict then Eidapl i []
	else Einfo noeval (Eidapl i [])
 || mks (Eidapl i el) =
	if arity_of_id i <= length el then
		Einfo strict (Eidapl i (map mks el))
	else
		Eidapl i (map mks el)
 || mks (Elamapl il e el) = Elamapl il (mks e) (map mks el)
 || mks (e as Einfo noeval _) = e
 || mks (Einfo strict e) = ms (mks e)
 || mks (Einfo i e) = Einfo i (mks e)

and mkstrict (e as Emodule i es bss) =
    if Strict | Semistrict then
	Emodule i es (map (mapsnd mks) bss)
    else
	e
end
