static int beenhere = 0;

static
sig(s, rep)
char *s;
int *rep;
{
    if (beenhere++)
	finish(1);
    fprintf(stderr, "Signal: %s\n", s);
#if DUMP
    ep = (int **)rep;
    dumpstack();
#endif
    finish(1);
}

/* the use of r11 and r10 here is extremely nonportable! */
sigbus() { register *r11, *r10; sig("Bus error", r10); }
sigsegv() { register *r11, *r10; sig("Segmentation fault", r10); }
sigill() { register *r11, *r10; sig("Illegal instruction", r10); }

static
Doerr(s, p)
char *s;
int **p; 
{ 
    int i;
    
    if (beenhere++)
	finish(1);
    fprintf(stderr, "Error in runtime system:\n");
#if DUMP
    fprintf(stderr, "%s on %s node.\n", s, tagname(p));
    for(i = 8; i < 38; i++){
	fprintf(stderr, "%8x  ", (&p)[i]);
    }
    dumpstack();
#endif
    finish(1);
}

EError(p)  int **p; {  Doerr("gettag (?)", p); }
EErre(p) int **p; { Doerr("eval", p);}
EErru(p) int **p; { Doerr("unwind", p);}
EErrj(p) int **p; { Doerr("jfun", p);}
EErrmk(p) int **p; { Doerr("mkapl", p);}
EErrg(p) int **p; { Doerr("gettag", p);}

ENolabel() { fprintf(stderr, "Jump to Nolabel: this cannot happen!\n"); finish(1);}

fail()
{
    if (beenhere++)
	finish(1);
    fprintf(stderr, "Fail:");
    printtop(stderr);
    fprintf(stderr, "\n");
    finish(1);
}

bigeqfail()
{
    fprintf(stderr, "Cannot compare functions.\n");
    finish(1);
}

noheapleft()
{
	fprintf(stderr, "\nOut of heap space\n");
	finish(1);
}
