module -- renamedef
--
-- $Header: /ufs/usr.src/local/lml/src/rename/RCS/renamedef.m,v 2.18 87/12/18 18:23:22 augustss Exp $
--
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/types.t.t"
#include "../expr/id.t"
#include "../expr/pprint.t"
#include "../transform/misc.t"
#include "../misc/misc.t"
#include "../misc/util.t"
#include "../misc/flags.t"
#include "../transform/lettrans.t"	-- andify
#include "renenv.t"
#include "renametype.t"
#include "fun.t"
/*import ren:	*a->Renv->Int->Texpr->(Int#Texpr);*/
#include "rename.t"	/* rename and renamedef are mutually recursive! */
#include "renameutil.t"
#include "renameclass.t"

export rendef;
rec
    rd  ff env u cp dd =
        if Pedantic then
	    let (u', d', env') = rdx ff env u cp dd in
	    let d'' = case filter badid (rids Kall env') in
		          [] : d'
		      ||  is : mkberror ("Bad identifiers in pedantic mode: "@mixmap oprid is ", ")
		      end
            in (u', d'', env')
	else
	    rdx ff env u cp dd
and
    rdx ff env u cp dd =
	case dd in
	   mkbrec d :
	    let rec (uu, nd, ne) = rd ff (rjoin ne env) u (addc (getcs d) cp) d in
	    let d' = if syncirc ne then 
		         mkberror "Circular type synonyms."
                     else
			 nd in
	    (uu, mkbrec d', ne)
	|| mkband d1 d2 :
	    let (u1, nd1, e1) = rd ff env u cp d1 in
	    let (u2, nd2, e2) = rd ff env u1 cp d2 in
	    (u2, mkband nd1 nd2, rjoin e1 e2)
	|| mkblocal d1 d2 :
	    let (u1, nd1, e1) = rd ff env u cp d1 in
	    let (u2, nd2, e2) = rd ff (rjoin e1 env) u1 (addc (getcs d1) cp) d2 in
	    (u2, mkblocal nd1 nd2, e2)
	|| mkbpat [pe as (p,e)] & (ismulti cp p) :
	    let ((b, ex), u1) = multi cp ff env pe u in
	    (u1, b, ex)
	|| mkbpat [(mkident (mkids s), e)] :
		let (u2, en) = ren ff env (u+1) e in
		let rec id = mkid u s idi_varu (ff id) in
		(u2, sdef id en, rone Kvalue id)
        || mkbpat (pes as ((p,_)._)) & (Curry & ismulti cp p) :		-- The parser&curry0 may have messed it up.  They don't know any better.
	       let (bexs, u1) = Umap (multi cp ff env) pes u in
	       let (bs, exs) = split bexs in
	       (u1, andify bs, reduce rjoin rnil exs)
	|| mkbpat pl : rd ff env u cp (fixfun cp pl)
	|| mkbtype _ _ _ : renbtype ff env u dd
	|| mkberror _ : (u, dd, rnil)
	|| mkbnull : (u, dd, rnil)
	|| mkbsyn t1 t2 : rensyntype ff env u dd
        || mkbclass t b : renclass ff env u dd
        || mkbinstance t b _ : reninst ff env u dd
        || mkbdefault ts : (u, mkbdefault (map (rentype env) ts), rnil)
        || mkbsign is t :
	       let is' = map (\(mkids s).rfind Kvalue s env) is in
	       (u,
	        (if exists (\i.id_no i=0) is' then
		   mkberror ("Unknown id among "@mix (map oprid is) ",")
	        else
		   mkbsign is' (rentype env t)),
	        rnil)
	end

and multi cp ff env (p, e) u =
        let pi = (filter (not o cp) (getids p)) in
	let ex = etag ff pi u idi_varu in
	let (u1, pn) = ren ff (rjoin ex env) (u+length pi) p in
	let (u2, en) = ren ff env u1 e in
	let I = newident u2 in
	((mkblocal (mkbpat [(I,en)]) (mkbmulti pn I), ex), u2+1)

and rendef ff env u dd =
	let (un, b, eext) = rd ff env u (isconstri env) dd in
	if anysame (rstrs Kvalue eext) | anysame (rstrs Ktype eext) then
	    let dups = (map hd o filter (\is.length is > 1) o group (=) o sort (<) o rstrs Kall) eext in
	    (u,
	     mkberror ("Multiple definition in let: " @ mix dups ", "),
	     rnil)
	else
	    (un, b, eext)
end
