--
-- $Header: /ufs/usr.src/local/lml/src/rename/RCS/rename.m,v 97.0 90/07/07 14:41:53 augustss Exp $
--
module -- rename
--
-- This module does the renaming.  The renaming is the process in which
-- every identifier gets a unique name.  This greatly simplifies further
-- transformations since there will be no risk of name clashes after the
-- renaming.
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/types.t.t"
#include "../expr/impexp.t.t"
#include "../expr/idtab.t"
#include "../expr/impexp.t"
#include "../expr/ttype.t"
#include "../expr/pprint.t"
#include "../misc/flags.t"
#include "../transform/misc.t"
#include "import.t"
#include "renenv.t"
#include "renamedef.t"
#include "renameutil.t"
#include "renametype.t"
#include "buildclass.t"
#include "buildinsts.t"
#include "classutil.t"
#include "deriv.t"
#include <Option>

export rename, ren;
rec
    ren ff env u e =
	case e in
	   mkap f a :
	    let (u1, fn) = ren ff env u f in
	    let (u2, an) = ren ff env u1 a in
	    (u2, mkap fn an)
	|| mklam (mkident i as (mkids s)) e1 & (~isconstri env i & ~isdummy i) :
            let rec ii = mkid u s idi_varu (ff ii) in
	    let (u1, en) = ren ff (rjoin1 env Kvalue ii) (u+1) e1 in
	    (u1, mklam (mkident ii) en)
	|| mklam e1 e2 :
	    let nid = mkident (mkids "I") in
	    ren ff env u (mklam nid (mkcase nid [(e1, e2)]))
	|| mkcase exp casel :
	    let (u1, e1) = ren ff env u exp in
	    let (u2, cl) = mapstate (renpb ff env) u1 casel in
	    (u2, mkcase e1 cl)
	|| mkletv def exp :
	    let (u1, defn, defs) = rendef ff env u def in
	    let (u2, en) = ren ff (rjoin defs env) u1 exp in
	    (u2, mkletv defn en)
	|| mkident i & (isdummy i) : (u, dollar)
	|| mkident (mkids s) : (u, findid s env mkident)
	|| mkident _ : (u, e)	-- already renamed, from FLIC
	|| mkconst _ : (u, e)
	|| mkas (mkids s) e :
	    let (u1, e1) = ren ff env u e in
	    (u1, findid s env (\i.mkas i e1))
	|| mkcondp p c :
	    let (u1, pn) = ren ff env u p in
	    let (u2, cn) = ren ff env u1 c in
	    (u2, mkcondp pn cn)
	|| mklazyp p:
	    let (u1, pn) = ren ff env u p in
	    (u1, mklazyp pn)
	|| mkinfo (restr t) e :
	    let (u1, e1) = ren ff env u e in
	    (u1, mkinfo (restr (rentype env t)) e1)
	|| mkinfo (spark is) e :
	    let (u1, e1) = ren ff env u e in
	    (u1, mkinfo (spark (map (\(mkids s).rfind Kvalue s env) is)) e1)
	|| mkinfo t e :
	    let (u1, e1) = ren ff env u e in
	    (u1, mkinfo t e1)
	|| mklistg e qs :
	    let (u1, e1, qs1) = renq ff env [] e u qs in
	    (u1, mklistg e1 qs1)
	-- mkmodule, mkerror, mkconstr, mkfailmatch cannot occur
	end

and renq ff env xs e u [] =
        let (u1, e1) = ren ff env u e in
	(u1, e1, reverse xs)
||  renq ff env xs e u (mkqfilter f.qs) =
        let (u1, e') = ren ff env u f in
	renq ff env (mkqfilter e'.xs) e u1 qs
||  renq ff env xs e u (mkqgen p g.qs) =
	let vl = filter (not o isconstri env) (getids p) in
	let vle = rjoin (etag ff vl u idi_varu) env in
	let (u1, p') = ren ff vle (u+length vl) p in
	let (u2, e') = ren ff env u1 g in
	renq ff vle (mkqgen p' e'.xs) e u2 qs

and isplus (mkids "_+") = true
||  isplus _ = false
and renpb ff env u (p, e) =
	let vl = filter (\i.~(isconstri env i | Curry&isplus i)) (getids p) in	-- I hate n+1 patterns!
	let vle = rjoin (etag ff vl u idi_varu) env in
	let (u1, pn) = ren ff vle (u+length vl) p in
	let (u2, en) = ren ff vle u1 e in
	(u2, (pn, en))

and rename u (mkmodule i fixs impl expl def) =
	    let rec (u0, ienv, nimpl) = importenv u [mkimport (mkids "_lmlimports") [] [] impl false [] []]
	    and     (u1, defn, defs) = rendef (mkffv i fixs (map expid nexpl)) ienv u0 def
	    and     exps = map (idtostr o expid) expl
	    and     (errl, nexpl) = renexplist exps defs in
	    let ne = mkmodule i fixs nimpl nexpl defn in
	    (u1, rjoin defs ienv, (\x.x),
	     (if null errl then
		ne
	     else -- we mustn't hide any errors, so make an appl.
	     	mkap (mkerror (concmap (\x.x@"\n") errl)) ne)
	    )
-- Return a suitable translation function instead of applying it now.
-- Later we can rename the hi* stuff as well.
||  rename u (mkhmodule id oexps imps fixs b) =
            let rec (u0, ienv, nimps) = himportenv u imps
	    and     exps = case oexps in Some es : es || None : xgetexps defs end
	    and     ff = mkffv id fixs (map expid nexpl)
            and     (u1, b', defs) = rendef ff ienv u0 (if NoToprec then droprec b else b)
	    and     env = rjoin denv (rjoin defs ienv)
	    and     (errl, nexpl) = hrenexplist exps env
	    and     ne = mkmodule id [] [] nexpl (mkband b' db)
	    and     dbl = dbldefs id env
            and     undefs = chkundefs ienv
            and     (c2i, t2i, ibads) = buildinsts env
	    and     (css, circs) = buildsuper env
	    and     (eder, denv, db, u2) = solvederiv ff defs ienv u1
            and     chfn = chfun idt
	    and     idt = ciidtab c2i t2i css (addmets env) in
--trace ("u1="@itos u1@",u2="@itos u2)
	    (u2, env, chfn,
	     if badmodname id then
		 mker ne ("Illegal module name: "@oprid id)
	     else if eder ~= [] then
		 mker ne ("Bad deriving for: "@mix eder ", ")
             else if undefs ~= [] then
		 mker ne ("Undefined : "@mix undefs ", ")
	     else if dbl ~= [] then
		 mker ne ("Multiply defined : "@mix dbl ", ")
	     else if circs ~= [] then
		 mker ne ("Circular class structure "@mix circs ", ")
             else if ibads ~= [] then
		 mker ne ("Bad instances "@mix ibads ", ")
	     else if errl~=[] then
		 -- we mustn't hide any errors, so make an appl.
		 mker ne (concmap (\x.x@"\n") errl)
	     else
		 ne)

and mker ne msg = mkap (mkerror msg) ne
and itl idt i = itlookupdef idt i i
and droprec (mkbrec b) = b
and chfun idt = changeid (itl idt)

and xgetexps env = concmap xexp (filter (\i.hd (idtostr i) = '_') (rids Kall env))
and xexp (i as mkid _ _ (idi_var _ _) _) = [mkexpid i]
||  xexp (i as mkid _ _ (idi_type _ _ _ _ _) _) = [mkexpidall i]
||  xexp (i as mkid _ _ (idi_syn _ _ _) _) = [mkexpid i]
||  xexp (i as mkid _ _ (idi_class _) _) = [mkexpidall i]
||  xexp _ = []
end
