module -- importpre
--
-- Get the library functions, but only when we need them.
-- There are some coding tricks here
--
#include <OK>
#include "../misc/flags.t"
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/impexp.t.t"
#include "../expr/read.t"
#include "../expr/types.t.t"
export implib, flimplib;
rec
    LMLENV	= "LMLDIR"		-- Environment variable for LML
and LIBDEF	= 			-- Default value of this variable
		  if nuflag then "/usr/local/lib/vlmlc"
		            else "/usr/local/lib/lmlc"
and MLIB	= "/lib/"		-- place to look for library functions
and PPRE	= "parsed/"		-- prefix for parsed files
and PSUF	= ".p"			-- suffix for parsed files
and INDEX	= "lib.index"		-- the index file

and LPREL	= "prelude.p"
and MPREL	= "PreludeMini.p"

and HLIB	= "/hlib/"		-- place to look for library functions
and HPRELS	= ["Prelude.p"; "PreludeCore.p"; "PreludeRT.p"; "PreludeType.p"]

and pref =
	case getenv LMLENV in
    	    Yes s : s
	||  No _  : LIBDEF
	end @ (if Curry then HLIB else MLIB)
and open f =
    	case openfile f in
	    No s  : fail (s@": "@f)
	||  Yes s : s
	end
-- Using name to set the name is a trick to avoid reading the file
-- if it isn't needed.  For this to work the files may only contain function
-- definitions.
and name f i =
	let (mkimpid _ t i) = i in
	mkimpid (mkids f) t i
and getfun f =
	let (r, i) = readimpid (open (pref@PPRE@f@PSUF)) in
	-- make sure we close the file
	name f (if r=r then i else fail "Huh?")

and flimplib = map getfun (choplist (splitat '\n') (open (pref@INDEX)))

and getimport s =
    case (readinterface s) in
	(" ", i) : i
    end

-- A hack
and lmlops = [ -- prec is wrong
 mkfixid (map mkids ["_~="; "_>="; "_<="; "_??"; "_+."; "_-."; "_*."; "_/."; "_+#"; "_-#"; "_*#"; "_/#"; "_%#"; "_."; "_="; "_>"; "_<"; "_+"; "_-"; "_*"; "_/"; "_%"; "_~"; "_&"; "_|"; "_@"; "_?"; "_^"]) (Infix 9)]

and minimplib = [getimport (open (pref@MPREL))]
and limplib = let (mkimport a b c d e f g) = getimport (open (pref@LPREL)) in [mkimport a b (lmlops@c) d e f g]
and himplib = map (\x.getimport (open (pref@x))) HPRELS
and implib = if NoPrelude then minimplib else if Curry then himplib else limplib
end
