module
#include "../Gcode/Gcodedef.t.t"
#include "machine.t"
#include "mcodedef.t.t"
#include "Wuse.t"
#include "mregs.t"

export 	H, Ha, newheapS, newS, newV, allpopV, allpopS, allWpush,
	intoareg, intoreg0, prepWuse, indS, strbc, strop, isbinarithop, mgop,
	maptag, mvektag, mtagtag, mniltag, mpairtag, mupdtag;
rec
    H n (hprel x) = hprel(x-n)
 || H n a = a
and
    Ha n (hprel x.S) = (hprel (x-n)).Ha n S
 || Ha n (popS   .S) = popS.S
 || Ha n (  a    .S) = a.Ha n S
 || Ha n [] = fail "fail Ha: empty S"
and
    newheapS n (Wpush)  S c = (Mmove (hprel(-n)) pushS.c, popS.S)
 || newheapS n (Wreg r) S c = (Mmove (hprel(-n)) (reg r).c, (reg r).Ha n S)
 || newheapS n (Wuse)   S c = (c , hprel(-n).Ha n S)
and
    newS a (Wpush) S c = (Mmove a pushS.c , popS.S)
 || newS (reg q) (Wreg r) S c = ((if q=r then c else Mmove (reg q) (reg r).c) 
 			        , reg r.S)
 || newS a (Wreg r) S c = (Mmove a (reg r).c , reg r.S)
 || newS a (Wuse) S c = (c , a.S)
 || newS _ _ _ _ = fail "newS"
and
    newV a (Wpush) V c = (Mmove a pushV.c , popV.V)
 || newV (reg q) (Wreg r) V c = ((if q=r then c else Mmove (reg q) (reg r).c) 
		 	      ,reg r.V)
 || newV a (Wreg r) V c = (Mmove a (reg r).c , reg r.V)
 || newV a (Wuse) V c = c , a.V
 || newV _ _ _ _ = fail "newV"
and
    allpopV = popV.allpopV
and allpopS = popS.allpopS
and allWpush = Wpush.allWpush
and
    intoareg (reg r) V S = [], r
 || intoareg a V S = let r = gareg V S in
 			[ Mmove a (reg r) ] , r
and
    intoreg0 (reg 0) c = c
 || intoreg0 a c = Mmove a (reg 0).c
and
    prepWuse 0 l = l
 || prepWuse n l = Wuse. prepWuse (n-1) l
and
    indS n (popS.S) = Sind n
 || indS 0 (x.S) = x
 || indS n (x.S) = indS (n-1) S
 || indS _ _ = fail "indS"
and
    strbc Gbint  = "INT"
 || strbc Gbchar = "CHAR"
 || strbc Gbtag  = "TAG0"
and
    strop EQ = "EQ"
 || strop NE = "NE"
 || strop GT = "GT"
 || strop LT = "LT"
 || strop LE = "LE"
 || strop GE = "GE"
 || strop ADD = "ADD"
 || strop SUB = "SUB"
 || strop MUL = "MUL"
 || strop DIV = "DIV"
 || strop MOD = "MOD"
and
    isbinarithop ADD = true
 || isbinarithop SUB = true
 || isbinarithop MUL = true
 || isbinarithop DIV = true
 || isbinarithop MOD = true
 || isbinarithop  _  = false
and
    mgop ADD = add
 || mgop SUB = sub
 || mgop MUL = mul
 || mgop DIV = div
 || mgop MOD = mod 

and maptag     = idlit "AP"
and mtagtag    = idlit "TAG"
and mniltag    = idlit "TAG0"
and mvektag    = idlit "VEK"
and mupdtag    = idlit "UPDTAG"
and mpairtag n = idlit ("PAIR"@itos n)
end
