module
#include "mcodedef.t.t"
#include "../Gcode/Gcodedef.t.t"
#include "Wuse.t"
#include "mutil.t"
#include "mutil1.t"
#include "mregs.t"
#include "mstrlbl.t"
#include "mstrid.t"
#include "handmade.mcode.t"
export mcnil, mcpair, mcstring, mctag, mcvek, mcfloat, mcinteger, mmvector;
mcnil t g G m V S =
	let ts = tmplbl t in
	let (con, ns) = if m <= 20 then (true, "CN"@itos m) else (false, ts)in
	let rec (c, d, uv, u.us, k) = M (t+1) g G V S1
	and    (c1, S1) = newS (idlit ns) u S c
	in (	Mcom ("CNIL "@itos m).
		(if con then c1 else
		Mdata.
		Mlabel ts.
		Mword mniltag.
		Mword (const m).
		Mtext.c1), d, uv, us, k)
and
mcpair t i G V abS =
	let (a.b.S) = abS in
	let ts = tmplbl t in
	let (con,ias,ibs,hh) =
		case (a,b) in (idlit ias,idlit ibs): (true, ias, ibs, 0)
			   || _ : (false, "", "", 3) end
	in
	let rec (c, d, uv, u.us, k) = M (t+1) 1 G V S1
	   and (c1, S1) = if con then newS (idlit ts) u S c
	   			 else newheapS 3 u S c
	in 
	    (	Mcom("CPAIR").
	    	(if con then
		    Mdata.
		    Mlabel ts.
		    Mword i.
		    Mword (glob ias).
		    Mword (glob ibs).
		    Mtext.
		    c1
		else
	    	    Mmove i tohp.
	    	    Mmove (H 1 a) tohp.
		    Mmove (H 2 b) tohp.c1),
		(if con then ts.d else d),
		    	uv, Wuse.Wuse.us, k+hh)
and
mcstring t g G s V S =
	let ts1 = tmplbl t 
	and ts2 = tmplbl (t+1)
	in
	let rec (c, d, uv, u.us, k) = M (t+2) g G V S1
	and    (c1, S1) = newS (idlit ts1) u S c
	in (	Mcom ("CSTRING").
		Mdata.
		Mlabel ts1.
		Mword (glob "STRING").
		Mword (glob ts2).
		Mword (const 0).
		Mlabel ts2.
		Mstring s.
		Mtext.
		c1,
			ts1.d, uv, us, k)
and
mcfloat t g G s V S =
	let ts1 = tmplbl t 
	in
	let rec (c, d, uv, u.us, k) = M (t+1) g G V S1
	and    (c1, S1) = newS (idlit ts1) u S c
	in (	Mcom ("CFLOAT").
		Mdata.
		Mlabel ts1.
		Mword (glob "DFLOAT").
		Mfloat s.
		Mtext.
		c1,
			ts1.d, uv, us, k)
and
mcinteger t g G s V S =
	let ts1 = tmplbl t 
	and ts2 = tmplbl (t+1)
	in
#if 1
	let is = Integer2IntList (stoI s) in
#else
	-- Bootstrap code for bignums
	let is = 
		let n = stoi s in
		[ if n = 0 then 0 else 1; 65536 + n] -- big-endian
		[ if n = 0 then 0 else 1; 65536*n + 1] -- little-endian
	in
#endif
	let rec (c, d, uv, u.us, k) = M (t+2) g G V S1
	and    (c1, S1) = newS (idlit ts1) u S c
	in (	Mcom ("CINTEGER").
		Mdata.
		Mlabel ts1.
		Mword (glob "BIGNUM").
		Mword (glob ts2).
		Mlabel ts2.
		Mword (glob "DVEK").
		Mword (const (length is)).
		map (Mword o const) is@
		Mtext.
		c1,
			ts1.d, uv, us, k)
and
mctag t G m V aS =
	let (a.S) = aS in
	let ts = tmplbl t in
	let (con,is,hh) = case a in idlit i:true, i ,0 
				 || _      :false,"",3 end in
	let rec (c, d, uv, u.us, k) = M (t+1) 1 G V S1
	and    (c1, S1) = if con then newS (idlit ts) u S c
			  	 else newheapS 3 u S c 
	in (	Mcom ("CTAG "@itos m).
		(if con then
		    Mdata.
		    Mlabel ts.
		    Mword mtagtag.
		    Mword (const m).
		    Mword (glob is).
		    Mtext.
		    c1
		else
		    Mmove mtagtag tohp.
		    Mmove (const m) tohp.
		    Mmove (H 2 a) tohp.c1),
		(if con then ts.d else d),
			uv, Wuse.us, k+hh )
and
mcvek t G m tag1 tag2 V S =
	let rec iscon 0 S = true
	     || iscon n (idlit _.S) = iscon (n-1) S
	     || iscon n S = false
	in
	let ts = tmplbl t in
	let con = iscon m S in
	let hh = if con then 0 else m+2 in
	let rec (c, d, uv, u.us, k) = M (t+1) 1 G V S1
	and     (c1, S1) = if con then newS (idlit ts) u (tail m S) c
				  else newheapS (m+2) u (tail m S) c
	in
	let rec toheap 0 S c = c
	     || toheap n (s.S) c = Mmove s tohp.toheap (n-1) (Ha 1 S) c
	    and todata 0 S = []
	     || todata n (idlit i.S) = Mword (glob i).todata (n-1) S
	in 
	   (	Mcom("CVEK "@itos m/*@prstk 5 S@prstk 5 S1*/).
	   	(if con then
		    Mdata.
		    Mlabel ts.
		    Mword tag1.
		    Mword tag2.
		    (if m = 0 then
		    	[Mword (const 0)]
		    else
		    	todata m S) @ (
		    	Mtext.
			c1)
		else
		    Mmove tag1 tohp.
		    Mmove tag2 tohp.
		    toheap m (Ha 2 S) c1),
		(if con & m ~= 0 then ts.d else d),
			uv, prepWuse m us, k+hh)

and mmvector i is t g G V S =
	let (c, d, v, s, k) = M t g G V S in
	let iname = mstrid i in
	   (Mcom "CMVECTOR".
	    Mtext.
	    Malign.
	    (if mexported i then [Mexport iname] else [])@
            Mlabel iname.
	    Mword mvektag.
	    Mword (const (length is)).
	    map (\f.Mword (glob (mstrid f))) is@
	    c, [], v, s, k)

#if 0
where
prstk n S = (show_list pamode (head n S)
where
rec preg n		= 'r'.itos n
and pamode Vp		= "Vp"
||  pamode (Vind n)	= itos n@"(Vp)"
||  pamode (Vrel n)	= '$'.itos n@"(Vp)"
||  pamode pushV	= "Vpush"
||  pamode popV		= "Vpop"
||  pamode Sp		= "Sp"
||  pamode (Sind n)	= itos n@"(Sp)"
||  pamode (Srel n)	= '$'.itos n@"(Sp)"
||  pamode pushS	= "Spush"
||  pamode popS		= "Spop"
||  pamode (reg n)	= preg n
||  pamode (regind n m)	= itos m@"("@preg n@")"
||  pamode (regrel n m)	= '$'.itos m@"("@preg n@")"
||  pamode hp		= "Hp"
||  pamode (hpind n)	= itos n@"(Hp)"
||  pamode (hprel n)	= '$'.itos n@"(Hp)"
||  pamode tohp		= "toH"
||  pamode (glob s)	= s
||  pamode (idlit s)	= '$'.s
||  pamode (const n)	= '$'.itos n
)
#endif
end
