-- $Header: /ufs/usr.src/local/lml/src/RCS/main.m,v 1.71 90/07/07 14:40:44 augustss Exp $
--

#include <OK>
#include "misc/flags.t"
#include "flic/flic.t"
#include "flic/fconstr.t"
#include "expr/read.t"
#include "expr/pprint.t"
#include "expr/error.t"
#include "rename/rename.t"
#include "rename/renameutil.t"
#include "rename/import.t"		/* startu */
#include "rename/renenv.t"		/* rids */
#include "transform/match.t"
#include "transform/constr.t"
#include "transform/lettrans.t"
#include "transform/remsign.t"
#include "transform/remclass.t"
#include "transform/remlazy.t"
#include "Expr/Ecnv.t"
#include "Expr/Eprint.t"
#include "Expr/apconv.t"
#include "Expr/eqtrans.t"
#include "Expr/classtrans.t"
#include "Expr/addrestr.t"
#include "Expr/prexport.t"
#include "Expr/hprexport.t"
#include "Expr/unrec.t"
#include "Expr/predef.t"
#include "type/tchk.t"
#include "type/prefix.t"
#include "llift/addclose.t"
#include "llift/llift.t"
#include "llift/Bconv.t"
#include "llift/addarity.t"
#include "Gcode/Gmain.t"
#include "Gcode/Gprint.t"
#include "Gopt/gopt.t"
#include "Gopt/goptgm.t"
#include "mcode/mcode.t"
#include "mcode/mprint.t"
#include "mopt/mopt.t"
#include "strict/strict.t"
#include "strict/mkstrict.t"
#include "strict/strictcon.t"
#include "simpl/simpl.t"
#include "mcode/machine.t"
#include "curry/curry0.t"
#include "zf/lmlzf.t"
#include "zf/remzf.t"
#include "version.t"
#include <OK>

#define MAXERRCHAR 4000

let display t e = t @ "\n" @ ppr e @ "\n" in
let Edisplay t e = t @ "\n" @ pr e @ "\n" in
let fp f t = if f then t else "" in
let rec getemsg [] = []
||      getemsg ([].r) = getemsg r
||      getemsg (a._) = head MAXERRCHAR (concmap (\e.e@"\n") a)
in
let fstderr = [TOSTDERR]
and fstdout = [TOSTDOUT]
in
let stopit emsg = fstderr@"Errors:\n"@emsg@"\nCompilation aborted\n"@failexit 1 in
let (inp, ftype, fotype, fasm, fgcode) =
	case basename in
	   No msg : fail msg
	|| Yes "" : (input, fstdout, fstdout, fstdout, fstdout)
	|| Yes n : 
		let (Yes s) = openfile (n@".p") in
		(s, tofile (n@".t"), tofile (n@".ot"), tofile (n@".s"), tofile (n@".g"))
	end
in
let (e0, errmap) = if InFlic then (flic input, []) else Read inp in
let e02 = if Curry then curry0 e0 else lmlzf e0 in
let (u1, env, trfun, e1) = rename startu e02 in
let (e1s, defs) = remsign (trfun e1) in
let (e1q, u2) = remzf e1s u1 in
let e1c = remclass e1q in
let (e2, u3) = constrtr e1c u2 in
let (e2z, u4) = remlazy e2 u3 in
let (e3, u5) = remmatch e2z u4 in
let e4 = trfun (remdeep e3) in
let E01 = Ecnv e4 in
let E02 = if NoUnrec then E01 else unrec E01 in
let (E0, u6) = addrestr E02 u5 in
let (terr, S, E1, npre, u7) = tcheck errmap E0 defs u6 in
let E11 = apconv E1 in
let E12 = classtrans E11 in
let E2 = eqtrans S E12 in
let E2p = predef E2 in
let (u8, E21) = if NoSimpl then (u7, E2p) else Esimpl u7 E2p in
let E31 = if NoStrictAnal then E21 else strictanal E21 in
let E32 = mkstrict E31 in	-- make it strict if Strict flag is on
let E3 = strictcon E32 in
let E4 = addclose E3 in --(addarity E3 []) in
let (E51,u9) = lambdalift E4 u8 in
let (E5,u10) = if NoBConv then (E51,u9) else Bconv E51 u9 in
let (hexp, hexperr) = case hprexport env E5 in Yes s : (s, []) || No s : ("", [s]) end in
let lexp = prexport E5 in
let (exp, oexp, experr) = if Curry then (hexp, lexp, hexperr) else (lexp, hexp, []) in
let E6 =  addarity E5 [] in
let gco0 = Gmain E6 in
let gco = if NoGOpt then gco0 else gopt gco0 in
let mco0 = mmain gco in
let mco = if NoMOpt then mco0 else mopt mco0 in
let ass = assemblercode mco in
let (EF2,u11) = lambdalift E51 u10 in
let (EF1,u12) = fconstr E4 u11 in
conc [
fstderr								;
(if Verbose then (if Curry then "Haskell B." else "LML") @ " " @ version @ ".\n" else "")			;
fstdout								;
fp PrErrmap     (concmap (\(f, (n, l))."\""@n@"\", line "@itos l@", def: "@f@"\n") (reverse errmap)) ;
fp PrInput 	(display "---Input:"    e0) 			;
fp PrCurry 	(display "---Curry:"    e02) 			;
fp PrRename 	(display "---Renamed:"  e1 @ "\nEnvironment has "@itos (length (rids Kall env))@" ids.\n") 			;
fp PrRemSign	(display "---Remsign:"  e1s)			;
--fp PrGenderiv	(display "---Genderiv:" e1g)			;
fp PrRemzf	(display "---Remzf:"    e1q)			;
fp PrRemClass	(display "---Remclass:" e1c)			;
fp PrConstr	(display "---Constr:"   e2) 			;
fp PrRemLazy	(display "---Remlazy:"	e2z)			;
fp PrRemmatch	(display "---Remmatch:" e3) 			;
fp PrRemdeep	(display "---Remdeep:"  e4) 			;
let emsg = getemsg (map (errors errmap) [e1; e1s; e1c; e2; e3]) in
if emsg ~= [] then
        stopit emsg
else (conc [
	fp PrEcnv	(Edisplay "---Ecnv:"    E01)		;
	fp PrAddfrom	(Edisplay "---Unrec:" E02)		;
	fp PrAddrestr	(Edisplay "---addrestr:"    E0)		;
	fp PrType	("---Type:\n" @ prpre npre @"\n"@pr E1)	;
let emsg = getemsg [terr] in
if emsg ~= [] then
        stopit emsg
else (conc [
	fp PrApconv	(Edisplay "---apconv:"  E11)		;
	fp PrClasstrans	(Edisplay "---classtrans:"  E12)	;
	fp PrEqtrans	(Edisplay "---eqtrans:"  E2)		;
	fp PrPredef	(Edisplay "---predef:"  E2p)		;
	fp PrSimpl	(Edisplay "---simpl:"  E21)		;
	fp PrOutFlic	(Etofprint  EF2)			;
	fp PrStrict	(Edisplay "---strict:"  E3)		;
	fp PrAddclose	(Edisplay "---addclose:" E4)		;
	fp PrLambdalift	(Edisplay "---lambdalift:" E51)		;
	fp PrBconv	(Edisplay "---Bconv:" E5)		;
	fp PrAddarity	(Edisplay "---addarity:" E6)		;
        fp PrInput	("Unique: "@show_list show_int [startu;u1;u2;u3;u4;u5;u6;u7;u8;u9;u10;u11/*;u12*/]@"\n")		;
	fp PrGcodeUnopt	("---Gcode unopt:\n" @ (Gprint gco0))	;
	fp PrGcode	("---Gcode:\n" @ (Gprint gco))		;
	fp Gflag	(fgcode@Gprint (goptgm gco)@fstdout)	;
	fp PrMcode	("---Mcode:\n" @ (mprint mco))		;
let emsg = getemsg [experr] in
if emsg ~= [] then
        stopit emsg
else (conc [
	ftype							;
	fp Type		exp					;
	(if Type & BothTypes then fotype @ oexp else "")	;
	fasm							;
	fp Code		ass
])
])
])
]

