--
-- Instances for integer (bignum) operations
-- 
module I_Integer() where
instance Ix Integer where
	range (l,h) = irange l h
	index (l,h) x = fromInteger (x - l)
	inRange (l,h) x = l <= x && x <= h

irange :: Integer->Integer->[Integer]
irange l h = if l > h then [] else l : irange (l+1) h


instance Enum Integer where
	enumFrom n = from n
	enumFromThen n m = fromi n (m - n)
	enumFromTo n m = if m > n then irange n m else irrange n m
	enumFromThenTo n m p = if m > n then iranges n (m-n) p else irranges n (m-n) p

from :: Integer -> [Integer]
from n = n : from (n+1)
fromi :: Integer -> Integer -> [Integer]
fromi n i = n : fromi (n+i) i
irrange :: Integer->Integer->[Integer]
irrange l h = if l < h then [] else l : irange (l-1) h
iranges :: Integer->Integer->Integer->[Integer]
iranges l i h = if l > h then [] else l : irange (l+i) h
irranges :: Integer->Integer->Integer->[Integer]
irranges l i h = if l < h then [] else l : irange (l+i) h

