module
export Id, Idinfo, Varinfo, Classinfo, Origname, Fixity, Visibility, Otype;
rec type Id =
	mkids (List Char) +
	mkid Int (List Char) Idinfo Origname
and type Idinfo =
	idi_udef +
	idi_var Varinfo Otype +
	/* constructor type, parameter type list, constr no, other con*/
	idi_constr Ttype (List(Ttype#Bool)) Int (List Atype) +
	idi_type Ttype Int Tinfo (List IDecl) (Option (List Id))+		-- Type (with context), # of tvars, constructors, class belongings, derived insts
	idi_syn Ttype Int Ttype +				-- Source (pattern), # of tvars, destination (body)
	idi_class Classinfo +
	idi_method (List Int) Int Classinfo +			-- Method number, arity, class info
	idi_inst IDecl (List Id) Bool +				-- Instance vector: instance declaration, method ids, derived inst flag
	idi_module (List Expid)					-- Module (with visible ids)
and type Varinfo =
	var_unknown +
	var_local Int +		-- binding depth
	var_global Finfo +	-- visible, arity (<0 indicates unknown), frame size
	var_pre Finfo		-- predefined (known by the compiler), with function info
and type Classinfo =
        clsi CDecl (List (Id#Id#Ttype)) (List (Id#(List Int))) (List (Id#IDecl)) Int		-- Type (with context), methods (default name, method name, type), superclasses, instances (=method vector,instance decl type), # of immediate superclasses
and type Fixity = Infix Int + InfixL Int + InfixR Int + Nofixity + FPrefix Int + FPostfix Int + Nonfix
and type Origname = Noorigname + Orignames Visibility Fixity (List (List Char))
and type Visibility = Vimported + Vexported + Vprivate
and type Otype = Onotype + Ohastype Ttype (List Int)
end
