--
-- $Header: /ufs/usr.src/local/lml/src/expr/RCS/id.m,v 97.0 90/07/07 14:39:08 augustss Exp $
--
module -- id
--
-- handles the identifier type
--
#include "../misc/flags.t"
#include "einfo.t.t"
#include "einfo.t"
#include "id.t.t"
#include "ttype.t"
#include "ttype.t.t"

#define PrMore false

export pprid, prid, oprid, eqid, ltid, idtostr, dummyid, asmid, idi_varu, arity_of_id, framesize_of_id, id_is_global, noorigname,
       id_is_visible, type_of_id, id_is_predef, id_no, isdummy, id_orignames, id_fixity, id_isvar, id_ismethod, mknewid, id_isclass, id_isinst, updorig, id_issyn, id_isconstr, id_metarity, id_metsel, updvis, id_visibility, updidname, inprelude;
rec
    idi_varu = idi_var var_unknown Onotype
and
    noorigname = Noorigname
--    noorigname = (fail "noorigname") : Origname
and
    dummyid = mkid 0 "_" idi_varu noorigname
and
    isdummy (mkids "_") = true
||  isdummy (mkid 0 _ _ _) = true
||  isdummy _ = false
and
    idtostr (mkids s) = s
||  idtostr (mkid n s i _) = s
and
    transid "$" = "$"		-- why??
||  transid l = (f1 l
where rec
    f1 "->" = "->"
||  f1 ('#'.l) = '#'.f l
||  f1 l = f l
and f "" = ""
||  f (c.l) & (isalnum c | c = '_') = c.f l
||  f (c.l) = ['$'; hex (ord c/16); hex (ord c%16)] @ f l
and hex n = select (n+1) "0123456789ABCDEF")
    -- convert an identifier to suit the assembler
and inprelude (('_'.'P'.'r'.'e'.'l'.'u'.'d'.'e'._)._) = true
||  inprelude _ = false
and asmid i = 
    if Curry then
	case i in
	    mkid _ _ _ (Orignames _ _ ss) & (~inprelude ss) : if FlatNames then transid (last ss) else mix (map transid ss) "$_"
	||  i : transid (idtostr i) --fail ("No original name for "@idtostr i)
        end
    else
	transid (idtostr i)
and
    prid' ('_'.s) & (~Fullname) = s
--||  prid' ('P'.s) & (~Fullname) = s
||  prid' s = s
and
    -- convert an identifier for outputting
    prid i = 
    if Debug then pprid i else
    case i in
       mkids s : prid' s
    || mkid n s i _ : prid' s
    end
-- In Haskell being an operator isn't enough, it must not be an alphanumeric operator
and oprid i =
    if Debug then pprid i
    else
	let s = prid' (idtostr i) in
        if (s = "") then
	    "_"
	else if Curry then
	    if isalpha (hd s) | s = "()" then
		s
	    else
		"("@s@")"
	else
	    if id_fixity i = Nofixity then
		s
	    else
		"("@s@")"

and
    pprid (mkids s) = s
#ifdef DEBUG
 || pprid (mkid n s i on) =
	if Debug then
		s@"{"@itos n@","@case i in
			    idi_udef : "udef"
			 || idi_var v ot : "var{"@prvar v@protype ot@"}"
			 || idi_constr _ _ n _ : "constr-"@itos n
			 || idi_type t _ _ ts _ : "type"@show_list clname ts
			 || idi_syn _ _ _ : "syn"
			 || idi_class c : "class "@prclsi c
			 || idi_method ns _ c : "method-"@show_list show_int ns@"-"@prclsi c
			 || idi_inst t _ _ : "inst"
			 || idi_module _ : "module"
			 end @ "}" @ (if PrOrignames then "="@proname on else "")
	else s
#else
 || pprid (mkid n s i _) = s
#endif
#ifdef DEBUG
and
    prvar (var_unknown) = "unknown"
 || prvar (var_local n) = "local "@itos n
 || prvar (var_global f) = "global "@prfinfo f
 || prvar (var_pre f) = "pre"
and prvis Vimported = "import"
 || prvis Vexported = "export"
 || prvis Vprivate = "local"
and prfix (Infix n) = "infix-"@itos n
||  prfix (InfixL n) = "infixl-"@itos n
||  prfix (InfixR n) = "infixr-"@itos n
||  prfix _ = "_"
and protype Onotype = ""
 || protype (Ohastype t _) = " "@prttype t
and proname Noorigname = "??"
 || proname (Orignames v f ss) = prvis v@" "@prfix f@show_list (\s.s) ss
and prclsi (clsi t iits xs its _) = show_list (\(_,i,_).idtostr i) iits@","@show_list (show_pair (idtostr,show_list show_int)) xs@","@show_list (idtostr o tyname o snd) its
and clname (mkidecl _ (c as mkid _ _ (idi_class cl) _) _ _) = idtostr c@(if PrMore then "<"@prclsi cl@">" else "")
||  clname (mkidecl _ c _ _) = "****"@idtostr c@"****"
and tyname (mkidecl _ _ ti _) = ti
#endif
and
    eqid (mkids s1) (mkids s2) = s1 = s2
 || eqid (mkid n1 _ _ _) (mkid n2 _ _ _) = n1 = n2
and
    ltid (mkids s1) (mkids s2) = s1 < s2
 || ltid (mkid n1 _ _ _) (mkid n2 _ _ _) = n1 < n2
and
    arity_of_id (mkid _ _ (idi_var (var_global f) _) _) = arity_of_finfo f
 || arity_of_id (mkid _ _ (idi_var (var_pre f) _) _) = arity_of_finfo f
 || arity_of_id _ = -1
and
    framesize_of_id (mkid _ _ (idi_var (var_global f) _) _) = framesize_of_finfo f
 || framesize_of_id _ = -1
and
    id_is_global (mkid _ _ (idi_var (var_global _) _) _) = true
 || id_is_global _ = false
and
    id_is_visible (mkid _ _ _ (Orignames Vexported _ _)) = true
||  id_is_visible (mkid _ _ _ (Orignames Vimported _ _)) = true
||  id_is_visible _ = false
and
    id_is_predef (mkid _ _ (idi_var (var_pre _) _) _) = true
||  id_is_predef _ = false
and
    id_no (mkid m _ _ _) = m
and 
    type_of_id (mkid _ _ (idi_var _ ot) _) = ot
||  type_of_id (mkid _ _ (idi_method ns _ (clsi ct iits _ _ _)) _) = 
        let (d,m,t) = select (last ns+1) iits in 
        (Ohastype t (getTvars t))
||  type_of_id _ = Onotype
and id_orignames (mkid _ _ _ Noorigname) = []
||  id_orignames (mkid _ _ _ (Orignames _ _ ns)) = ns
and id_fixity (mkid _ _ _ (Orignames _ f _)) = f
||  id_fixity _ = Nofixity
and id_visibility (mkid _ _ _ (Orignames v _ _)) = v
||  id_visibility _ = Vprivate
and id_isvar (mkid _ _ (idi_var _ _) _) = true
||  id_isvar _ = false
and id_ismethod (mkid _ _ (idi_method _ _ _) _) = true
||  id_ismethod _ = false
and id_metsel (mkid _ _(idi_method k _ _) _) = k
and id_metarity (mkid _ _ (idi_method _ k _) _) = k
and mknewid s n = mkid n (s@itos n) idi_varu noorigname
and id_isclass (mkid _ _ (idi_class _) _) = true
||  id_isclass _ = false
and id_isinst (mkid _ _ (idi_inst _ _ _) _) = true
||  id_isinst _ = false
and updorig id [] = id
||  updorig (mkid x y z (Orignames v f _)) on = mkid x y z (Orignames v f on)
and id_issyn (mkid _ _ (idi_syn _ _ _) _) = true
||  id_issyn _ = false
and id_isconstr (mkid _ _ (idi_constr _ _ _ _) _) = true
||  id_isconstr _ = false
and updvis vi (mkid n s v (Orignames _ f on)) = mkid n s v (Orignames vi f on)
||  updvis _ i = i
and updidname (mkid n _ i on) s = mkid n s i on
end
