module -- eqtrans
-- Insert bigeq instead of eq where necessary.
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/constr.t.t"
#include "../expr/einfo.t.t"
#include "../type/subst.t.t"
#include "../type/subst.t"
#include "../type/unify.t"
#include "Expr.t.t"
#include "../funnos.h"
#include "../misc/misc.t"
#include "../misc/util.t"
#include "../misc/flags.t"
#include "../transform/hexpr.t"

export eqtrans;
rec
    bigt = [
(hieq, mkid Fbigeq "Pbigeq" idipre2f noorigname);
(hine, mkid Fbigne "Pbigne" idipre2f noorigname);
(hile, mkid Fbigle "Pbigle" idipre2f noorigname);
(hige, mkid Fbigge "Pbigge" idipre2f noorigname);
(hilt, mkid Fbiglt "Pbiglt" idipre2f noorigname);
(higt, mkid Fbiggt "Pbiggt" idipre2f noorigname)
]
and tagt = [
(hieq, mkid Feq "Peq" idipre2 noorigname);
(hine, mkid Fne "Pne" idipre2 noorigname);
(hile, mkid Fle "Ple" idipre2 noorigname);
(hige, mkid Fge "Pge" idipre2 noorigname);
(hilt, mkid Flt "Plt" idipre2 noorigname);
(higt, mkid Fgt "Pgt" idipre2 noorigname)
]
and big i = assocdefeq eqid i bigt (fail "big")
and tag i = assocdefeq eqid i tagt (fail "big")
and idipre2f = idi_var (var_pre (finfo 2 [true;true] false 2)) Onotype
and idipre2  = idi_var (var_pre (finfo 2 [true;true] true 2)) Onotype
and cmpop i = member eqid i [hieq; hine; hile; hige; hilt; higt]
and notarrow t = 
	case Unify t (Tarr Tvar1 Tvar2) in
	   ok _ _ : false
	|| bad _ : true
	end
and bas S (Einfo (trestr t) _) = flattype (TRtype S t)
||  bas S _ = false
and eqtrans S e = if Curry then e else eqt true S e
and
    eqt b S (Emodule i expl dl) = Emodule i expl (map (mapsnd (eqt b S)) dl)
||  eqt b S (Ecase e pl dp) = 
   		Ecase (eqt false S e) (mapthd (eqt true S) pl) (eqt true S dp)
||  eqt b S (Elet r dl e) = Elet r (mapsnd (eqt false S) dl) (eqt b S e)
||  eqt b S (Econstr c el) = Econstr c (map (eqt false S) el)
||  eqt b S (e as Efailmatch n) = e
||  eqt true S (Einfo (trestr t) (e as Eidapl _ [])) =
    let tx = TRtype S t in
	if notarrow tx then
		Einfo (noarrow tx) e
	else
		e
||  eqt b S (Eidapl i (el as [_;_])) & (cmpop i) =
        if exists (bas S) el then
	    Eidapl (tag i) (map (eqt false S) el)
	else
	    Eidapl (big i) (map (eqt false S) el)
||  eqt b S (Eidapl i el) = Eidapl i (map (eqt false S) el)
||  eqt b S (Elamapl il e el) = Elamapl il (eqt true S e) (map (eqt false S) el)
||  eqt b S (Einfo (restr _) e) = eqt b S e
||  eqt b S (Einfo (trestr _) e) = eqt b S e
||  eqt b S (Einfo f e) = Einfo f (eqt b S e)
||  eqt b S _ = fail "eqtrans"
end
