--  stylemenu.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- This package describes menus, it works in tandem with style.m
--
-- Modified 8.2.88 to implement the generalised menu package.
--   Menus are called with an extra function which generates a layout
--   structure. So the same package describes all sorts of menu styles.


module

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "fonts.t"
#include "tree.t"
#include "gdc.t"
#include "style.t"

export PosStringType,AreaDesType,LayoutType,
       Vert,LJVert,Horiz,PopUpMenu,PopUpMenuAt,MenuTest,StaticMenuObj;

rec
    type PosStringType = PS CoordType FontType Int ColourType (List Char) +
			 PSDummy

and type AreaDesType   = AD CoordType ColourType ShapeType Bool
                           (List PosStringType) +
			 ADDummy

and type LayoutType    = LO AreaDesType (List AreaDesType) +
			 LODummy

----------------------
-- Layout Functions --
----------------------

and SelectStr n l =
    let (AD pos col shp ol strs) = select n l
    in strs

and Vert fnt scl strs = 
   let rec 
       Marg = scl * 2
   and TextHeight = scl * 3 / 2 
   and MaxHeight = (length strs * TextHeight) + Marg
   and MaxWidth  = MaxStringWidth strs fnt scl + Marg
   and MainArea = AD (0^0) White (Rect (MaxWidth^MaxHeight)) true []
   and SubAreas x y [] = []
   ||  SubAreas x y (h.t) =
       AD (x^y) White (Rect ((MaxWidth-Marg)^TextHeight)) false
	  [PS (((MaxWidth-StringWidth fnt scl h-Marg+1)/2)^(scl / 3)) 
	     fnt scl Black h].SubAreas x (y-TextHeight) t
   in LO MainArea (SubAreas scl (MaxHeight-scl-TextHeight) strs)

and LJVert fnt scl strs = 
   let rec 
       Marg = scl * 2
   and TextHeight = scl * 3 / 2 
   and MaxHeight = (length strs * TextHeight) + Marg
   and MaxWidth  = MaxStringWidth strs fnt scl + Marg
   and MainArea = AD (0^0) White (Rect (MaxWidth^MaxHeight)) true []
   and SubAreas x y [] = []
   ||  SubAreas x y (h.t) =
       AD (x^y) White (Rect ((MaxWidth-Marg)^TextHeight)) false
	  [PS (0^(scl / 3)) fnt scl Black h].SubAreas x (y-TextHeight) t
   in LO MainArea (SubAreas scl (MaxHeight-scl-TextHeight) strs)

and Horiz fnt scl strs = 
   let rec 
       Marg = scl * 2
   and TextHeight = scl * 3 / 2 
   and MaxHeight = scl * 2
   and MaxString = MaxStringWidth strs fnt scl
   and MaxWidth  = MaxString * (length strs) + Marg
   and MainArea = AD (0^0) White (Rect (MaxWidth^MaxHeight)) true []
   and SubAreas x y [] = []
   ||  SubAreas x y (h.t) =
       AD (x^y) White (Rect (MaxString^TextHeight)) false
	  [PS (((MaxString-StringWidth fnt scl h+1)/2)^(scl / 3))
	   fnt scl Black h].SubAreas (x+MaxString) y t
   in LO MainArea (SubAreas scl (scl / 4) strs)

-- Menu functions --

and PopUpMenuAt b style prnt dpth ml cl =
       When (IsMsDep b) (SubPopUpMenuAt b style prnt dpth ml cl)

and SubPopUpMenuAt b style prnt dpth ml cl s (Ms Lft Dep n crds.t) =
       PopUpMenu b style prnt (select dpth crds) ml cl s (Ms Lft Dep n crds.t)

and PopUpMenu b style prnt pos ml cl ((n,ds),s) =
       let rec 
	   (Strings,Actions) = split ml
       and Layout = style Strings
       in  Seq [RejectInput; DrawMenu false Layout pos prnt;
		AllMsInterest b Rel Screen; InteractMenu b Layout prnt;
		MenuChoice b prnt (ActList Actions (n + 1)) cl] ((n,ds),s)

and StaticMenuObj b style prnt pos ml =
    let rec
	(Strings,Actions) = split ml
    and Layout = style Strings
    in (DrawMenu true Layout pos prnt,StaticMenuRules Layout Actions 1)

and StaticMenuRules lt acts m ((n,ds),s) l =
    if m > length acts then []
    else OCons 0 (IsMs Lft Dep (n-length acts+m-1)) (select m acts) .
	 OCons 0 (IsMsEnN (n-length acts+m-1)) (SHighlight lt) .
	 OCons 0 (IsMsExN (n-length acts+m-1)) (SDeHighlight lt) .
	 StaticMenuRules lt acts (m+1) ((n,ds),s) l

and SHighlight lt cl = Seq [Highlight lt; TreeCase cl]

and SDeHighlight lt cl = Seq [DeHighlight lt; TreeCase cl]

and ActList [] n = []
||  ActList (h.t) n = (n,h) . ActList t (n+1)

and ActOn [] n cl = TreeCase cl
||  ActOn ((i,a).t) n cl = if n=i then a cl else ActOn t n cl

and DrawMenu sw lt pos prnt = Join (MenuBase lt pos prnt) (MenuText sw 1 lt prnt)

and MenuBase (LO (AD p col shp ol strs) text) pos prnt =
    if ol then OutlinePopCanvas 0 prnt pos (0^0) 0 (100^100) 4 col shp
    else PopCanvas 0 prnt pos (0^0) 0 (100^100) col shp

and MenuText sw n (LO bs []) prnt = NullDialogue
||  MenuText sw n (LO bs (AD pos col shp ol strs.t)) prnt =
    Seq [Canvas n (Child o prnt) pos (0^0) 0 (100^100) col shp ;
	 DrawText strs prnt;
	 SChangeCursor (Child o Child o prnt) RhtPtr;
	 SInMsEn (Child o Child o prnt); SInMsEx (Child o Child o prnt);
	 if sw then SInMs Lft Dep (Child o Child o prnt) 
	 else NullDialogue;
         MenuText sw (n+1) (LO bs t) prnt]
	 
and DrawTextAt n [] = NullDialogue
||  DrawTextAt n (PS pos fnt scl col str.t) =
    Join (Send (Text n pos fnt scl col str)) (DrawTextAt n t)

and DrawWhiteTextAt n [] = NullDialogue
||  DrawWhiteTextAt n (PS pos fnt scl col str.t) =
    Join (Send (Text n pos fnt scl White str)) (DrawWhiteTextAt n t)

and DrawText [] prnt = NullDialogue
||  DrawText (PS pos fnt scl col str.t) prnt =
    Join (SText (Child o Child o prnt) pos fnt scl col str) (DrawText t prnt)

and InteractMenu b lt prnt = 
       Until (IsAllMs b Rel)
	     (Case [MenuMsEn prnt ~> Highlight lt;
                    MenuMsEx prnt ~> DeHighlight lt])

and MenuMsEn prnt ((next,ds),s) (MsEn n x y . t) = 
    NodeNum (Parent (Parent (TreeFind n ds))) = NodeNum (prnt ds)
||  MenuMsEn prnt s l = false

and MenuMsEx prnt s (MsEx n x y . t) = true
||  MenuMsEx prnt s l = false

and Highlight (LO bs txt) ((next,ds),s) (MsEn n x y.t) = 
    Seq [Send (Fill n Black); RejectInput;
         DrawWhiteTextAt n (SelectStr (NodeObj (TreeFind n ds)) txt)] 
	     ((next,ds),s) (MsEn n x y . t)

and DeHighlight (LO bs txt) ((next,ds),s) (MsEx n x y . t) = 
    Seq [Send (Fill n White); RejectInput;
	 DrawTextAt n (SelectStr (NodeObj (TreeFind n ds)) txt)]
	     ((next,ds),s) (MsEx n x y . t)

and MenuChoice b prnt al cl s (AllMs bp Rel n crds. t) =
       Seq [SKillDecendants (Child o prnt);SKillCanvas (Child o prnt);
	    Send (RevokeAllMs b Rel); RejectInput;
	    ActOn al n cl] s (AllMs bp Rel n crds. t)

and MenuTest str = Obj [Print (str @ "\n")]

-----------------------------
-- Miscellaneous functions --
-----------------------------

and MaxStringWidth l fnt scl = max (map (StringWidth fnt scl) l)
end
