-- muntest8.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- Interprocess communications demo, HyperText !!

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "fonts.t"
#include "gdc.t"
#include "tree.t"
#include "dict.t"
#include "style.t"
#include "stylemenu.t"

-------------------------
-- Dialogue definition --
-------------------------

let rec 
       type TextType = Text (List (List Char)) +
		       Link (List Char) (List Char)

   and type ParaType = Left FontType Int Int (List TextType) +
		       Middle FontType Int Int (List TextType)

   and type CardType = Card (List Char) (List ParaType) +
		       ErrorCard (List Char)

-----------------------------------------------------
-- Diagnostic routines to display a card structure --
-----------------------------------------------------

and ShowCard (Card nme p) = "Card " @ nme @ "\n" @ concmap ShowPara p
|| ShowCard (ErrorCard s) = "ErrorCard : " @ s @ "\n"

and ShowPara (Left f s of t) = "Left :" @ concmap ShowText t @ "\n"
||  ShowPara (Middle f s of t) = "Middle :" @ concmap ShowText t @ "\n"

and ShowText (Text t) = "Text [" @ concmap show_string t @ "]"
||  ShowText (Link l w) = "Link (" @ l @ ")(" @ w @")"

--------------------------
-- Dialogue definitions --
--------------------------

and HyperText = Seq [Send (StartApp "hp");WaitForApp;Send (MessApp "start");
		     TreeCase [OCons 0 IsReceive DisplayCard]]

and NewCard str cl s =
    Seq [RejectInput; Cond (CardExists str)
			   (ElevateCard (CardWithName str s) TopCanvas cl) 
			   (Join (Send (MessApp str)) (TreeCase cl))] s

and WaitForApp st (AppMess s.t) = 
       Join (Print ("UIMS receives " @ s @ "\n")) RejectInput st (AppMess s.t)

and DisplayCard cl s (AppMess crd.t) = 
       Seq [OpenFixedWindow (Golden 5) White; 
            OutlineCanvas 0 Child (5^470) (0^0) 0 (100^100) 2 White
	       (Rect (25^25));
            SInMs Lft Dep (Child o Child); 
            SBitmap (Child o Child) (1^1) (23^23) "oak.im8";
            DrawCard Child (LeftMarg^TopMarg) (ParseCard crd) cl]
	    s (AppMess crd.t)

and AddMenu cn pn cl = 
    OCons 0 (IsMs Lft Dep cn) (CardMenu pn ((ChildWithNum pn) o Child)).cl

and CardMenu pc prnt = PopUpMenuAt Lft (Vert Helvetica 18) prnt 2
		["Move" ~> MoveCard (Golden 5) ((ChildWithNum pc) o prnt);
		 "Delete" ~> DeleteCard pc;
		 "Top" ~> ElevateCard pc TopCanvas;
		 "Bottom" ~> ElevateCard pc BottomCanvas;
		 "Quit" ~> ExitDialogue]

and     ElevateCard pc f = Obj [Send (f pc)]

and     ExitDialogue cl = Send (MessApp "/Q")

and DeleteCard pc cl s = 
    Seq [Do (RemoveCard pc) (SKillCanvas ((ChildWithNum pc) o Child));
	 TreeCase (DeleteObjs (= pc) cl)] s

and LeftMarg = 40 and RightMarg = 680 and TopMarg = 460 and BottomMarg = 40

and DrawCard area pos (Card nme paras) cl ((n,ds),s) = 
    let rec PN = NodeNum (area ds)
    and     CN = NodeNum (Child (area ds))
    in Do (AddCard nme PN) (DrawParas area pos paras PN (AddMenu CN PN  cl))
       ((n,ds),s)
||  DrawCard area pos (ErrorCard txt) cl ((n,ds),s) =
    let rec PN = NodeNum (area ds)
    and     CN = NodeNum (Child (area ds))
    in Seq [SText area (LeftMarg^TopMarg) Helvetica 18 Black txt;
   	    TreeCase (AddMenu CN PN cl)] ((n,ds),s)

and DrawParas area pos [] pn cl = TreeCase cl
||  DrawParas area (Cart x y) (Left fnt scl off txt.t) pn cl =
    let SS = StringWidth fnt scl " "
    in DrawPara area (Cart LeftMarg (y - off)) fnt scl SS txt t pn cl 

and DrawPara area pos fnt scl ss [] op pn cl = DrawParas area pos op pn cl
||  DrawPara area (Cart x y) fnt scl ss (Link li w . t) op pn cl =
    let rec SW = StringWidth fnt scl w 
    in if SW + x > RightMarg 
       then DrawLink area (Cart LeftMarg (y-scl)) fnt scl ss li w t op pn cl
       else DrawLink area (Cart x y) fnt scl ss li w t op pn cl
||  DrawPara area pos fnt scl ss (Text txt.t) op pn cl = 
       DrawText area pos fnt scl ss txt t op pn cl

and DrawLink area (Cart x y) fnt scl ss l w ot op pn cl =
    let rec Bnd = scl / 6 
    and     SW = StringWidth fnt scl w 
    in Seq [SText area (Cart x y) fnt scl Black w;
	    SLineDraw area ((x-Bnd)^(y-Bnd)) (0^0) 0 (100^100) 2 Black
	       (Rect ((SW+(2*Bnd))^scl));
	    ClearCanvas 0 area (Cart x y) (0^0) 0 (100^100) (Rect (SW^scl));
	    SChangeCursor (Child o area) RhtPtr;
	    SInMs Lft Dep (Child o area);
	    AddLinks l area (Cart (x+SW+ss) y) fnt scl ss ot op pn cl]

and AddLinks l area pos fnt scl ss ot op pn cl ((n,ds),s) = 
    DrawPara area pos fnt scl ss ot op pn (AddLink (Child o area) ds l pn cl)
    ((n,ds),s)

and DrawText area pos fnt scl ss [] ot op pn cl =
       DrawPara area pos fnt scl ss ot op pn cl
||  DrawText area (Cart x y) fnt scl ss (h.t) ot op pn cl =
    let rec SW = StringWidth fnt scl h
    in if SW+x > RightMarg 
       then Join (SText area (Cart LeftMarg (y-scl)) fnt scl Black h)
	         (DrawText area (Cart (LeftMarg+SW+ss)(y-scl)) fnt scl ss 
		  t ot op pn cl)
       else Join (SText area (Cart x y) fnt scl Black h) 
	         (DrawText area (Cart (x+SW+ss) y) fnt scl ss t ot op pn cl)

and AddLink area tr l pn cl =
    OCons pn (IsMs Lft Dep (NodeNum (area tr))) (NewCard l) . cl

-----------------------------------------------
-- Parsing routines, create a card structure --
-----------------------------------------------

and ParseCard crd = SubParse (BreakIntoWords crd)

and SubParse ("/C".cardname.t) = Card cardname (ParseBody t)
||  SubParse crd = ErrorCard "The hypertext server is unable to find this card"

and ParseBody [] = []
||  ParseBody ("/R".fnt.scl.offs.t) = 
    let rec (Text,Rest) = ParseTextLinks [] t
    in Left (StringToFont fnt) (stoi scl) (stoi offs) Text.ParseBody Rest

and ParseTextLinks a [] = (reverse a,[])
||  ParseTextLinks a ("/L".lnk.wrd.t) = ParseTextLinks (Link lnk wrd.a) t
||  ParseTextLinks a ("/R".t) = (reverse a,"/R".t)
||  ParseTextLinks a (h.t) =
    let rec (Txt,Rest) = ParseText [] (h.t)
    in ParseTextLinks (Text Txt.a) Rest

and ParseText a [] = (reverse a,[])
||  ParseText a ("/R".t) = (reverse a,"/R".t)
||  ParseText a ("/L".t) = (reverse a,"/L".t)	
||  ParseText a (h.t) = ParseText (h.a) t

and BreakIntoWords [] = []
||  BreakIntoWords (h.t) = if isspace h then BreakIntoWords t
			   else SubBreakIW "" (h.t)

and SubBreakIW a "" = [reverse a]
||  SubBreakIW a (h.t) = 
      if isspace h then reverse a.BreakIntoWords t
      else SubBreakIW (h.a) t

and StringToFont "Helvetica" = Helvetica
||  StringToFont "TimesRoman" = TimesRoman

and ShowFont Helvetica = "Helvetica"
||  ShowFont TimesRoman = "TimesRoman"

------------------------
-- Dict manipulation --
------------------------

and AddCard nme num (t,dict) = (t,Assoc nme num dict)

and CardWithName str (t,dict) = Find str dict

and CardExists str (t,dict) l = Exists str dict

and RemoveCard n (t,s) = (t,Remove n s)

---------------------
-- Main expression --
---------------------

in Dialogue HyperText (InitDS,[]) input
