-- muntest6.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- Tanagrams demo

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "gdc.t"
#include "tree.t"
#include "style.t"

-------------------------
-- Dialogue definition --
-------------------------

let rec Tanagram = Seq [Initialise; Play]

and     Initialise =
	   Seq [OpenFixedWindow (Golden 5) LightGray;
		OutlineCanvas 0 Background (50^50) (0^0) 0 (100^100) 4 White
		(Rect (152^400));
	        SInMs Lft Rel Background;
		SBitmap Panel (4^250) (142^142) "oak.im8";
		SDrawButton (10^160) (130^60) Panel White "Quit";
		DrawTan (76^76) Panel TanA; DrawTan (1^1) Panel TanB;
		DrawTan (1^1) Panel TanC;   DrawTan (76^1) Panel TanD;
		DrawTan (76^1) Panel TanE;  DrawTan (114^39) Panel TanF;
		DrawTan (114^39) Panel TanG]

and     Play = TreeCase [
          OCons 0 (SIsMs Lft Dep QuitButton) (ConfirmedExit Background);
	  OCons 0 (SIsMs Lft Dep TanAButton) (PlaceTan TanAButton TanA);
	  OCons 0 (SIsMs Lft Dep TanBButton) (PlaceTan TanBButton TanB); 
	  OCons 0 (SIsMs Lft Dep TanCButton) (PlaceTan TanCButton TanC);
 	  OCons 0 (SIsMs Lft Dep TanDButton) (PlaceTan TanDButton TanD);
	  OCons 0 (SIsMs Lft Dep TanEButton) (PlaceTan TanEButton TanE);
	  OCons 0 (SIsMs Lft Dep TanFButton) (PlaceTan TanFButton TanF);
	  OCons 0 (SIsMs Lft Dep TanGButton) (PlaceTan TanGButton TanG)]

and     DrawTan org prnt tan  = 
	    Seq [OutlineCanvas 0 prnt org (0^0) 0 (100^100) 2 Red (Ngon tan);
		 SChangeCursor (Child o prnt) Bullseye;
		 SInMs Lft Dep (Child o prnt)]

and     PlaceTan button shape cl  =
	    Seq [SFill button White;
		 SLineDraw button (0^0) (0^0) 0 (100^100) 2 Black (Ngon shape);
		 SRevokeMs Lft Dep button;
		 RejectInput;
                 OutlinePopCanvas 0 Background (350^50) (0^0) 0 (200^200) 8 
		 Cyan (Ngon shape);
	         SInMs Lft Dep (Child o Background);
	         SInMs Mid Dep (Child o Background);
	         SInMs Rht Dep (Child o Background);
		 AddTan shape cl] 

and     AddTan shp cl ((n,ds),s) = 
         Do (StateTan shp) 
	    (TreeCase ((OCons 0 (IsMs Lft Dep (n-1))(MoveTan (n-1) shp)).
	              (OCons 0 (IsMs Mid Dep (n-1)) (RotLeftTan (n-1) shp)).
		      (OCons 0 (IsMs Rht Dep (n-1)) (RotRightTan (n-1) shp)).cl))
	    ((n,ds),s)

and     StateTan shp ((n,ds),s) = ((n,ds),((n-1,(350^50),0,shp).s))

and     MoveTan tan shp cl ((next,ds),s) = 
         Seq [RejectInput;
	     SAnimate Background (AngOf tan s) (200^200) (Ghost (Ngon shp));
	     WaitForRelease Background;
	     Send (RevokeAnimate);
	     Send (KillCanvas tan);
	     MoveCanState tan;
	     DrawBigTan tan shp;
	     TreeCase cl] ((next,ds),s)

and     WaitForRelease b = Cond (SIsMs Lft Rel b) NullDialogue
			   (Join RejectInput (WaitForRelease b))

and     RotLeftTan tan shp = RotTan (RotLeftState tan) tan shp

and     RotRightTan tan shp = RotTan (RotRightState tan) tan shp

and     RotTan sf tan shp =
	   Obj [RejectInput;
	       Send (KillCanvas tan);
	       Do sf (DrawBigTan tan shp)] 

and    DrawBigTan tan shp ((next,ds),s) =
        let rec Pos = PosOf tan s
        in Seq [Send (OpenOutlinePopCanvas tan Pos Pos (AngOf tan s)(200^200) 8 
	        (NodeNum (Background ds)) Cyan (Ngon shp));
		MsInterest Lft Dep tan;
		MsInterest Mid Dep tan;
		MsInterest Rht Dep tan] ((next,ds),s)

and     MoveCanState tan ((next,ds),s) (Ms Lft Rel c (Cart x y.crds).t) =
	let rec NewState = MvState tan ((x/5)*5) ((y/5)*5) s
	and     MvState n x y ((can,pos,a,shp).t) = 
		   if can=n then ((can,(x^y),a,shp).t)
		   else ((can,pos,a,shp).MvState n x y t)
	in DC [] ((next,ds),NewState) t

and     RotLeftState n ((next,ds),s) =
	let rec NewAng = RLS n s
	and     RLS c ((can,pos,a,shp).t) = 
	           if c = can then ((can,pos,a+45,shp).t)
	           else ((can,pos,a,shp). RLS c t)
	in ((next,ds),NewAng)

and     RotRightState n ((next,ds),s) =
	let rec NewAng = RLS n s
	and     RLS c ((can,pos,a,shp).t) = 
	           if c = can then ((can,pos,a-45,shp).t)
	           else ((can,pos,a,shp). RLS c t)
	in ((next,ds),NewAng)

and     ExitDialogue cl = NullDialogue

and     AngOf c ((can,pos,a,shp).t) = if c = can then a else AngOf c t

and     PosOf c ((can,pos,a,shp).t) = if c = can then pos else PosOf c t

and     Background = EldestChild

and     Panel = EldestChild o EldestChild

and     QuitButton = YChildNum 7 o Panel

and     TanAButton = YChildNum 6 o Panel

and     TanBButton = YChildNum 5 o Panel

and     TanCButton = YChildNum 4 o Panel

and     TanDButton = YChildNum 3 o Panel

and     TanEButton = YChildNum 2 o Panel

and     TanFButton = YChildNum 1 o Panel

and     TanGButton = YChildNum 0 o Panel

--------------
-- The Tans --
--------------
and TanA = [0^0; 75^75; Minus 76^75]

and TanB = [0^0; 75^75; 0^151]

and TanC = [0^0; 75^0; 37^37]

and TanD = [0^0; 38^38; 0^76; Minus 38^37]

and TanE = [0^0; 75^0; 75^75]

and TanF = [0^0; 37^37; 37^113; 0^75]

and TanG = [0^0; 0^75; Minus 38^37]

and     StartTans = []

in Dialogue Tanagram (InitDS,StartTans) input
