-- munin.m
--
-- The Munich graphics model, implemented in NeWS (and LML)
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- Input commands

module

#include "munout.t"
#include "ps.t"


export ButtonType,ActType,EventType,
       InMs,InAllMs,InMsEn,InMsEx,InMsMv,InKbd,
       RevokeMs,RevokeMsMv,RevokeKbd,RevokeAllMs,
       SuspendMs,SuspendMsMv,SuspendKbd,SuspendAllMs,
       ResumeMs,ResumeAllMs,
       Events;

-- Functions to manipulate the graphics model. They are all public.

rec 
    type ButtonType = Lft + Mid + Rht

and type ActType    = Dep + Rel

and type EventType  = Ms ButtonType ActType Int (List CoordType) +
		      AllMs ButtonType ActType  Int CoordType +
		      MsEn Int Int Int +
		      MsEx Int Int Int +
		      MsMv Int Int Int +
		      Kbd Int Int +
		      AppMess (List Char) +
		      Tick + 
		      EventError

-- Interests

and InMs b a n = CanId n @ 
	       "/M" @ CapButtonCode b @ CapActCode a @
	       " (m" @ ButtonCode b @ ActCode a @ ")" @
	       PsAct a @ PsButton b @ " mint\n"


and InAllMs b a n = CanId n @ 
	       "/AM" @ CapButtonCode b @ CapActCode a @
	       " (am" @ ButtonCode b @ ActCode a @ ")" @
	       PsAct a @ PsButton b @ " mant\n"

and InMsEn n = CanId n @ "men\n"

and InMsEx n = CanId n @ "mex\n"

and InMsMv n = CanId n @ "mmv\n"

and InKbd n = CanId n @ "ik\n"

-- Revokes

and RevokeMs b a n = CanId n @ "/M" @ CapButtonCode b @ CapActCode a @ " rk\n"

and RevokeMsMv n = CanId n @ "/MMV rk\n"

and RevokeKbd = "KBD killprocess\n"

and RevokeAllMs b a = "AM" @ CapButtonCode b @ CapActCode a @ " killprocess\n"

-- Suspends

and SuspendMs b a n = CanId n @ "/M" @ CapButtonCode b @ CapActCode a @ "sus\n"

and SuspendMsMv n = CanId n @ "/MMV sus\n"

and SuspendKbd = "KBD suspendprocess\n"

and SuspendAllMs b a = "AM" @ CapButtonCode b @ CapActCode a @ " suspendprocess\n"

-- Resumes

and ResumeMs b a n = CanId n @ "/M" @ CapButtonCode b @ CapActCode a @ " res\n"

and ResumeAllMs b a n = "AM" @ CapButtonCode b @ CapActCode a @ " continueprocess\n"

-- Recognise events, (List Char) -> (List EventType)

and Alpha l = SubAlpha "" l

and SubAlpha s (h.t) = if isalnum h then SubAlpha (h.s) t
		       else (reverse s, t)

and Numeric l = SubNumeric "" l

and SubNumeric s (h.t) =  if isdigit h | h = '-' then SubNumeric (h.s) t
		          else (stoi (reverse s), t)
and Events l = 
	let (Str,Rest) = Alpha l
	in if Str = "mld" then Make Lft Dep Rest
	   else if Str = "mmd" then Make Mid Dep Rest
	   else if Str = "mrd" then Make Rht Dep Rest
	   else if Str = "mlr" then Make Lft Rel Rest
	   else if Str = "mmr" then Make Mid Rel Rest
	   else if Str = "mrr" then Make Rht Rel Rest
	   else if Str = "amld" then MakeAll Lft Dep Rest
	   else if Str = "ammd" then MakeAll Mid Dep Rest
	   else if Str = "amrd" then MakeAll Rht Dep Rest
	   else if Str = "amlr" then MakeAll Lft Rel Rest
	   else if Str = "ammr" then MakeAll Mid Rel Rest
	   else if Str = "amrr" then MakeAll Rht Rel Rest
	   else if Str = "men" then MakeMsEn Rest
	   else if Str = "mex" then MakeMsEx Rest
	   else if Str = "mmv" then MakeMs Rest
	   else if Str = "kb" then MakeKbd Rest
	   else if Str = "am" then MakeAppMess Rest
	   else if Str = "tk" then Tick . Events Rest
	   else MakeError Rest

and MakeXY l =
	let rec (X,Rest1) = Numeric l
	and     (Y,Rest) = Numeric Rest1
	in (X,Y,Rest)

and MakeString s (h.t) =
   if h = chr 0 then (reverse s,t)
   else MakeString (h.s) t

and MakeCoordList a ('*'.'\n'.t) = (reverse a,t)
||  MakeCoordList a l =
    let rec (X,Rest1) = Numeric l
    and     (Y,Rest2) = Numeric Rest1
    in MakeCoordList ((Cart X Y).a) Rest2

and Make b a l =
	let rec (Can,Rest1) = Numeric l
	and     (Coords,Rest) = MakeCoordList [] Rest1
	in (Ms b a Can Coords). Events Rest

and MakeAll b a l =
	let rec (Can,Rest1) = Numeric l
	and     (X,Y,Rest2) = MakeXY Rest1
	in (AllMs b a Can (Cart X Y)). Events Rest2

and MakeMsEn l =
	let rec (Can,Rest1) = Numeric l
	and     (X,Y,Rest) = MakeXY Rest1
	in (MsEn Can X Y). Events Rest

and MakeMsEx l =
	let rec (Can,Rest1) = Numeric l
	and     (X,Y,Rest) = MakeXY Rest1
	in (MsEx Can X Y). Events Rest

and MakeMs l =
	let rec (Can,Rest1) = Numeric l
	and     (X,Y,Rest) = MakeXY Rest1
	in (MsMv Can X Y). Events Rest

and MakeAppMess l =
   let (Str,Rest) = MakeString "" l 
   in (AppMess Str). Events Rest

and MakeKbd l =
	let rec (Num,Rest) = Numeric l
	and     (Num2,Tail) = Numeric Rest
	in (Kbd Num Num2). Events Tail

and MakeError ('\n'.t) = EventError.Events t
||  MakeError (h.t) = Events t

-------------------------
-- Buttons and Actions --
-------------------------

and ButtonCode Lft = "l"
||  ButtonCode Mid = "m"
||  ButtonCode Rht = "r"

and CapButtonCode Lft = "L"
||  CapButtonCode Mid = "M"
||  CapButtonCode Rht = "R"

and PsButton Lft = " /LeftMouseButton"
||  PsButton Mid = " /MiddleMouseButton"
||  PsButton Rht = " /RightMouseButton"

and PsAct Dep = " /DownTransition"
||  PsAct Rel = " /UpTransition"

and ActCode Dep = "d"
||  ActCode Rel = "r"

and CapActCode Dep = "D"
||  CapActCode Rel = "R"

end
