#include "/usr/NeWS/clientsrc/include/psio.h"
#include "hp.h"
#include <ctype.h>

char *malloc();

/* Constants */

#define FALSE 0
#define TRUE 1
#define MAXBUFSIZE 5000
#define NAMEBUFSIZE 200

/* Types */

typedef int bool;

typedef struct ccell {
    struct ccell *next;
    char         *name;
    long         pos;
} cardcell, *cardptr;

/* Global variables */

char *buf;             /* Message buffer */
FILE *hf;              /* Hypertext data file */
cardptr cardlist;      /* List of card positions in file */

main()
{
   bool not_finished = TRUE;

   if (ps_open_PostScript() == 0)
   {
      fprintf(stderr,"Can not connect to UIMS\n");
      exit(-1);
   }
   else
   {
      /* Initialise message buffer and comunications */

      cprint("Hypertext started\n");
      buf = (char *) malloc(MAXBUFSIZE);
      init();

      /* Open and parse hypertext file */

      if ((hf = fopen("/u/augustsson/andy/hp.txt","r")) == NULL)
      {
	 cprint("Can not open hp.txt\n");
	 exit(-1);
      }

      parse();

      /* await orders from user interface */

      send_message("/S");
      while (not_finished)
      {
	  rec_message(buf);
	  if (strcmp(buf,"/Q") == 0)
	  {
	     cprint("Hypertext receives quit signal");
	     cprint(buf);
	     cprint("\n");
	     not_finished = FALSE;
	  }
	  else
	  {
	     sendcard(); 
	 }
      }
   }
   ps_close_PostScript();
}

parse()
{
/* read the entire data file (hf) and create a list of positions for each
   name */

   cardptr nextcard;
   cardptr newcard;
   long    bytecount = 0;
   char    ch;
   char    *bufptr;
   char    *namebuffer;

   cardlist = (cardptr) malloc(sizeof(cardcell));
   cardlist -> next = NULL;
   nextcard = cardlist;
   namebuffer = malloc(NAMEBUFSIZE);

   while ((ch = getc(hf)) != EOF)
   {
      if (ch == '/')
      {
	 ch = getc(hf);
	 if (ch == 'C')
	 {
	    nextcard -> pos = bytecount;
	    ch = getc(hf);
	    bytecount += 2;
	    while (isspace(ch))
	    {
	       ch = getc(hf);
	       bytecount++;
	    }
	    bufptr = namebuffer;
	    do
	    {
	       *bufptr = ch;
	       ch = getc(hf);
	       bufptr++;
	       bytecount++;
	    }
	    while(!isspace(ch));
	    *bufptr = '\0';
	    nextcard -> name = malloc(strlen(namebuffer) + 1);
	    strcpy(nextcard -> name, namebuffer);
	    bytecount++;

	    newcard = (cardptr) malloc(sizeof(cardcell));
	    newcard -> next = NULL;
	    nextcard -> next = newcard;
	    nextcard = newcard;
	 }
	 else
	 {
	    bytecount += 2;
	 }
      }
      else
      {
	 bytecount++;
      }
   }
}

sendcard()
{
    cardptr nextcard = cardlist;
    long bytecount;
    bool found = FALSE;
    char *bufptr;

    while (nextcard -> next != NULL)
    {
       if (strcmp(nextcard -> name,buf) == 0)
       {
	  fseek(hf,nextcard -> pos,0);
	  bufptr = buf;
	  for (bytecount = nextcard -> pos; bytecount < nextcard -> next ->
	       pos; bytecount++)
	  {
	     *bufptr = getc(hf);
	     bufptr++;
	  }
	  *bufptr = '\0';
	  send_message(buf);
	  found = TRUE;
	  break;
       }
       else
	  nextcard = nextcard -> next;
    }
    if (!found)
       send_message("/F");
}
