-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "errortype.t"
#include "isittype.t"
#include "splittype.t"

export getargs;

-- getargs : Decode a list of arguments, and return a tuple describing them.
--  	     Takes a list of arguments as argument. (:-)

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/getargs.m,v 1.1 88/04/19 17:05:03 pelle Exp $"
and
    getargs = reduce decodearg (Isn't,Nosplit,false,[])
    where
    	decodearg ('-'.flags) x = (reduce decodeflags x flags
    	where
	    decodeflags 's' (file,Nosplit,verbose,e) = file,Dosplit,verbose,e
    	||  decodeflags 's' (file,Dosplit,verbose,e) =
		file,Supersplit,verbose,e
    	||  decodeflags 's' (file,Supersplit,verbose,e) =
    	        file,Supersplit,verbose,TooManyFlags 's'.e
    	||  decodeflags 'v' (file,split,false,e) = file,split,true,e
    	||  decodeflags 'v' (file,split,true,e) =
    	    	file,split,true,TooManyFlags 'v'.e
    	||  decodeflags c (file,split,verbose,e) =
		file,split,verbose,UnknownFlag c.e)
    ||  decodearg file (Isn't,split,verbose,e) =
	    (Is basefile,split,verbose,e' where
    	    	basefile,e' = basename file
	    	where rec
	    	    basename ".ff" = [],e
    	    	||  basename (x.tail) = let f,e = basename tail in x.f,e
	    	||  basename [] = [],MissingFFSuffix.e)
    ||  decodearg file (Is $,split,verbose,e) =
	    Is file,split,verbose,MultipleFile.e

end
