-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include <OK>
#include "actions.t"
#include "assoctype.t"
#include "conflicttype.t"

#define iff =
infix "precede";
infix "relates_to";

-- resolve actions : Actions is a list of symbol-action pairs.  Resolve
--		     will resolve conflicts in this list if there are
--		     more than one action for each symbol.  A list with
--		     at most one action for each symbol and a list of
--  	    	     conflicts are returned.

export resolve;

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/conflict.m,v 1.1 88/04/19 17:04:54 pelle Exp $"
and
    resolve (prods,$,$,$,$,$,$,$,$,assocs,$) = (part o rslv o sort resolveorder
    	where
	    resolveorder (s1,p1) (s2,p2) = s1 < s2 | s1 = s2 & (p1 precede p2
	    	where
		    (Shift $) precede (Reduce $) iff true
	    	||  (Reduce p1) precede (Reduce p2) iff
		    	case getredpri p1 in
			    NoPri : false
			||  Pri $ prec1 :
				case getredpri p2 in
				    NoPri : true
				||  Pri $ prec2 : prec1 > prec2
				end
			end
		||  $ precede $ iff false)
	and
	    part = (reduce prt ([],[])
		where
		    prt (Yes x) (xs,ys) = x.xs, ys
		||	prt (No y) (xs,ys) = xs, y.ys)
	and rec
	    rslv [] = []
	||  rslv [a] = [Yes a]
	||  rslv ((hd as (s1,$)).tl as (s2,$).$) & (s1~=s2) = Yes hd . rslv tl
	||  rslv ((hd1 as (s,a1)).(hd2 as (s',a2)).tl) /* & (s = s') */ =
		case a2 relates_to a1 in -- arguments reversed for convenience
		    Left, err : err @ rslv (hd2.tl)
		||  Right,err : err @ rslv (hd1.tl)
		||  None, err : err @ rslv (filter ((~= s) o fst) tl)
		end
		where
		    local
			before (Pri dir1 lvl1) (Pri dir2 lvl2) =
			    if lvl1 > lvl2 then Left
			    else if lvl1 < lvl2 then Right
			    else dir1 -- = dir2 in this case
		    and
			shpri = assocs s
		    in
			(Reduce rno) relates_to (Shift shno) =
			    (if shpri = NoPri | redpri = NoPri
				then Right, [No (ShiftReduce s shno rno)]
				else before redpri shpri, []
			    where
				redpri = getredpri rno)
		    ||  (Reduce no1) relates_to (Reduce no2) =
			    (if no1 < no2 then Left else Right),
			    [No (ReduceReduce s no1 no2)]
		    end)
	where
	    getredpri num =
		let
		    $,$,$,pri,$ =
			hd (filter (\ ($,$,$,$,pnum) . num = pnum) prods)
		in
		    pri

end
