-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "splittype.t"
#include "progtype.t"
#include "actions.t"
#include "codefuncs.t"
#include "attrcode.t"
#include "statecode.t"

export code;

-- code file split grammar states
--  	    	    : the code to implement a machine for a set of states
--  	       file : base name of the constructed file
--  	      split : tells how much the code should be split up
--  	     states : a list of states, each state consisting of a pair
--  	    	      of lists of pairs of strings and actions, (q.v).
--  	    	      The return value is a list of pairs, each
--  	    	      describing a module.  The first component of the
--  	    	      pair is a suffix to be appended to the filename,
--  	    	      and the second the code for that module.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/code.m,v 1.1 88/04/19 17:04:52 pelle Exp $"
and
    code file split (grammar as prods,$,$,$,$,fun,lookup,$,$,$,incid) states =
        let rec
            numbers = map itos (from 0)
        and
    	    includes = map lookup incid
        and
            reducefuncs = map (attrcode grammar) prods
        and
	    reducemodules =
	        (map reducecode prods
	        where
	    	    reducecode (p as $,$,$,$,n) =
	    	        'r'.num@".m",
		        MkModule inc [] [fun ('r'.num)] (attrcode grammar p)
		        where
		    	    inc = "OK" . includes @ map (file @) ["lt.t";"t.t"]
		        and
		    	    num = itos n)
        and
    	    standardmodules =
    	        ["lt.m", MkModule [] [] exports (And (localdecs grammar))
	        where exports = map fun ["bottom"; "Prodtype"; "Stacktype"];
	        "t.m", MkModule [] [] exports (And (standarddecs grammar))
	        where exports = [fun "Lextype"];
	        ".m", MkModule inc [] [fun ""] (parsedec grammar)
	        where inc = map (file @) ["lt.t"; "t.t"; "s0.t"]]
        in
    	    case split in
	        Nosplit :
    	    	    [".m",
	    	    MkModule
    	    	        ("OK" . includes)
	    	        []
	    	        exports
	    	        (Local
	    	    	    (And (localdecs grammar))
	    	    	    (Rec (And
	    	    	        (statefuncs @
		    	        reducefuncs @
		    	        parsedec grammar . standarddecs grammar))))
    	    	    where
        	        statefuncs = map (statecode grammar) states
		    and
    	    	        exports = map fun [""; "Lextype"]]
	    ||  Dosplit :
	    	    standardmodules @
		    (map shiftcodes (groupstates states)
		    where
		        shiftcodes (modno,content,statdepend,reddepend) =
		    	    's'.itos modno@".m",
			    MkModule
			        incl
			        []
			        exports
			        (Rec (And
				    (map
				        (statecode grammar)
				        (filter
					    (\(s,$,$).mem s content)
					    states))))
			    where
			        exports = map ((fun "s" @) o itos) content
			    and
			        incl =
				    "OK" .
				    map (file @) ["lt.t"; "t.t"] @
				    map
				        (((file @ "r") @) o (@ ".t") o itos)
				        reddepend @
				    map
				        (((file @ "s") @) o (@ ".t") o itos)
				        statdepend) @
		    reducemodules
    	    ||  Supersplit :
    	    	    standardmodules @
		    (map shiftcode states
	    	    where
	    	        shiftcode (s as no,na,ta) =
	    	    	    's'.itos no@".m",
			    MkModule
			        incl
				imp
				[fun ('s'.itos no)]
				(statecode grammar s)
		    	    where
		    	        local
		    	    	    sh, re =
				        (reduce red ([],[]) (map snd (na@ta))
			    	    where
			    	        red (Shift n) (sh,re) = n.sh, re
			    	    ||  red (Reduce n) (sh,re) = sh, n.re)
		    	        in
		    	    	    imp = map (impstate grammar) (mkset sh)
		    	        and
		    	    	    incl =
				        "OK" .
			    	        map (file @) ["lt.t"; "t.t"] @
			    	        map
				    	    (((file@"r")@) o (@".t") o itos)
					    (mkset re)
		    	        end) @
		    reducemodules
    	    end

end
