(* trace-cml.sig
 *
 * COPYRIGHT (c) 1990 by John H. Reppy.  See COPYRIGHT file for details.
 *
 * This provides a server to watch for uncaught exceptions in threads.
 *)

signature TRACE_CML =
  sig
    structure CML : CONCUR_ML
    val setTraceFn : ((CML.thread_id * exn) -> unit) -> unit
  end (* TRACE_CML *)

functor TraceCML (
    structure CML : INTERNAL_CML
          and RunCML : RUN_CML
    sharing CML = RunCML.CML
  ) : TRACE_CML = struct

    structure CML = CML

    fun defaultTraceFn (tid, ex) = (
	  CML.reportError (implode [
	      "uncaught exception ", System.exn_name ex, " in thread ",
	      CML.tidToString tid
	    ]))
    val initFn = ref defaultTraceFn

    fun startup () = let
	  val traceFn = !initFn
	  fun server () = (traceFn(CML.accept CML.errCh); server())
	  in
	    CML.spawn server; ()
	  end

    val _ = RunCML.logServer ("TraceCML", startup, fn () => ())

    fun setTraceFn f = (initFn := f)
    fun resetTraceFn () = (initFn := defaultTraceFn)

  end (* functor TraceCML *)
