\verb"#standard arith ..." \conceptindex{\verb"#standard arith ..."}

There are 2 arithmetical modes in CAML, identified by the value of the
directive \verb"#standard arith": 
\begin{itemize}
\item using the standard arithmetic, only small integers and floating point
numbers are recognized  by default, floating point arithmetic is an
approximate arithmetic and small integer arithmetic is an exact ring
arithmetic, 
\item using the non-standard arithmetic, all numbers are recognized by default 
of type \verb"num". Rational operations are performed exactly.
Transcendental operations are not defined on type \verb"num": they can
only be applied on floating point representations of numbers, using
explicit coercions. 
\end{itemize}
Of course, any number can be read as an entity of (almost)  any type, using
the lexical  convention associated to  this type (no lexical convention for
type \verb"nat").

By default, the mode is the standard one, but this can be changed using the 
\verb"#standard arith" directive.
\begin{small}
\begin{verbatim}
#standard arith false;;
\end{verbatim}
\end{small}
tells the compiler to use mathematical arithmetic instead of the standard one.
Of course, 
\begin{small}
\begin{verbatim}
#standard arith true;;
\end{verbatim}
\end{small}
undoes this.

For more information, see chapter ``Directives and pragmas'' in the reference 
manual. 
