\begin{caml_primitive}
is_integer_num : num -> bool
integer_num : num -> num
floor_num : num -> num
round_num : num -> num
ceiling_num : num -> num
\end{caml_primitive}
\conceptindex{\verb"is_integer"}
\conceptindex{\verb"floor"}
\conceptindex{\verb"round"}
\conceptindex{\verb"ceiling"}
\conceptindex{\verb"numerator"}
\conceptindex{\verb"integer"}

\verb"is_integer_num" is equivalent to:
\begin{small}
\begin{verbatim}
let is_integer_num = function
  Ratio r   -> is_integer_ratio r
|     _     -> true
;;
\end{verbatim}
\end{small}


\verb"integer_num" is the odd function of truncature for rational numbers.

\verb"floor_num" (resp. \verb"round_num", \verb"ceiling_num") are the 
mathematical functions for rounding to the lower (resp. nearest, higher) 
integer.

\exple
\begin{small}
\begin{verbatim}
#is_integer_num #{1.2e3/1200};;
true : bool

#integer_num #{1/3};;
#{0} : num

#floor_num #{1/3};;
#{0} : num

#round_num #{1/3};;
#{0} : num

#ceiling_num #{1/3};;
#{1} : num

#integer_num #{1/2};;
#{0} : num

#floor_num #{1/2};;
#{0} : num

#round_num #{1/2};;
#{1} : num

#ceiling_num #{1/2};;
#{1} : num

#integer_num #{-1/3};;
#{0} : num

#floor_num #{-1/3};;
#{-1} : num

#round_num #{-1/3};;
#{0} : num

#ceiling_num #{-1/3};;
#{0} : num

#integer_num #{-1/2};;
#{0} : num

#floor_num #{-1/2};;
#{-1} : num

#round_num #{-1/2};;
#{-1} : num

#ceiling_num #{-1/2};;
#{0} : num
\end{verbatim}
\end{small}
