\begin{caml_primitive}
sys_num_of_string : int * string * int * int -> num
num_of_string : string -> num
\end{caml_primitive}
\conceptindex{coercion between types \verb"string" and \verb"num"}

CAML is able to read numbers of type \verb"num" entered directly, according 
to the following lexical convention:

\begin{small}
\begin{verbatim}
Separator ::= ' ' | '\f' | '\n' | |\r' | '\t' | '\\'
Pseudodigit ::= Digit | Separator
Decimal ::= {'-'| '+'} Separator* Digit Pseudodigit* 
            {'.' Separator* Digit Pseudodigit*} {'e' {'-' | '+'} INT}
NUM ::= '#{' Decimal {'/' Decimal} '}'
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
##{12};;
#{12} : num

##{12.0};;
#{12} : num

##{1.2e1};;
#{12} : num

##{120e-1};;
#{12} : num

##{12/1};;
#{12} : num

##{60/5};;
#{12} : num

##{1.2/1e-1};;
#{12} : num

##{120/10};;
#{12} : num
\end{verbatim}
\end{small}

Using non standard arithmetic, the \verb"#{" and \verb"}" characters are 
optional (see chapter~\ref{numdir} for more information).

\verb"sys_num_of_string (base, s, off, len)" maps the substring 
$s_{off, len}$ in base \verb"base" onto a element of type \verb"num".

\verb"num_of_string s" is equivalent to:
\begin{small}
\begin{verbatim}
let num_of_string s = 
  sys_num_of_string (#10, s, #0, length_string s)
;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#sys_num_of_string (#16, "FF", #0, #2);;
#{255} : num

#num_of_string "1.2e3/5e1";;
#{24} : num
\end{verbatim}
\end{small}
