\begin{caml_primitive}
sys_string_of_ratio : int * string * ratio * string -> string
string_of_ratio : ratio -> string
string_for_read_of_ratio : ratio -> string
sys_print_ratio : int * string * ratio * string -> unit
print_ratio : ratio -> unit
print_ratio_for_read : ratio -> unit
\end{caml_primitive}
\conceptindex{coercion between types \verb"string" and \verb"ratio"}

\verb"sys_string_of_ratio (base, before, r, after)" returns the
concatenation of the string \verb"before", the string representation of 
rational number \verb"r" in base \verb"base", and finally the string
\verb"after". 
In fact if the approximation when printing rational numbers is turned on, 
the result is the floating point approximation to the floating point precision 
of the rational number. This is not implemented for $\verb"base " \neq 10$.
For more information see section~\ref{approxratio} and chapter~\ref{numdir}.

\verb"string_of_ratio r" is equivalent to:
\begin{small}
\begin{verbatim}
let string_of_ratio r = 
  sys_string_of_ratio (#10, "", r, "")
;;
\end{verbatim}
\end{small}

\verb"string_for_read_of_ratio r" is analogous to \verb"string_of_ratio r" 
except that the number is written between \verb"#[" and \verb"]", according to 
conventions to write ``big'' numbers. 

It is equivalent to:
\begin{small}
\begin{verbatim}
let string_for_read_of_ratio r =
 sys_string_of_ratio (#10, "#[", r, "]")
;;
\end{verbatim}
\end{small}

\verb"sys_print_of_ratio (base, before, r, after)" prints the 
\verb"base"-radix representation of the rational number \verb"r" between 
strings \verb"before" and \verb"after". It is equivalent to:
\begin{small}
\begin{verbatim}
let sys_print_ratio (base, before, r, after) =
 print_string (sys_string_of_ratio (base, before, r, after))
;;
\end{verbatim}
\end{small}

\verb"print_ratio" and \verb"print_ratio_for_read" are equivalent to:
\begin{small}
\begin{verbatim}
let print_ratio r = sys_print_ratio (#10, "", r, "");;

let print_ratio_for_read r = sys_print_ratio (#10, "#[", r, "]");;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#sys_string_of_ratio 
#  (#16, "ratio 16-radix representation = ", #[1.2e3/1.1e2], "");;
"ratio 16-radix representation = 78/B" : string

#sys_string_of_ratio 
#  (#2, "ratio 2-radix representation = ", #[1.2e3/1.1e2], "");;
"ratio 2-radix representation = 1111000/1011" : string

#sys_string_of_ratio 
#  (#8, "ratio 8-radix representation = ", #[1.2e3/1.1e2], "");;
"ratio 8-radix representation = 170/13" : string

#sys_string_of_ratio 
#  (#10, "ratio 10-radix representation = ", #[1.2e3/1.1e2], "");;
"ratio 10-radix representation = 120/11" : string

#string_of_ratio #[1.2e3/1.1e2];;
"120/11" : string

#string_for_read_of_ratio #[1.2e3/1.1e2];;
"#[120/11]" : string

#sys_print_ratio (#16, "ratio 16-radix representation = ", #[1.2e3/1.1e2], "");;
ratio 16-radix representation = 78/B() : unit

#print_ratio #[1.2e3/1.1e2];;
120/11() : unit

#print_ratio_for_read #[1.2e3/1.1e2];;
#[120/11]() : unit
\end{verbatim}
\end{small}
