\begin{caml_primitive}
sys_int_of_nat  : nat * int * int -> int
int_of_nat : nat -> int
nat_of_int  : int -> nat
\end{caml_primitive}
\conceptindex{coercion between types \verb"int" and \verb"nat"}

\verb"sys_int_of_nat (nat, off, len)" converts subnat $nat_{off, len}$ into an
\verb"int" when it is possible.

\verb"int_of_nat" converts its argument into an \verb"int" when it is
possible. This function is semantically equivalent to: 
\begin{small}
\begin{verbatim}
let int_of_nat nat = sys_int_of_nat (nat, #0, length_nat nat);;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #2;;
Value nat is #<0> : nat

#set_digit_nat (nat, #0, #1024);;
() : unit

#complement_nat (nat, #1, #1);;
() : unit

#debug_print_nat nat;;
|FFFFFFFF|00000400|() : unit

#sys_int_of_nat (nat, #0, #1);;
1024 : int

#sys_int_of_nat (nat, #1, #1);;

Evaluation Failed: failure "sys_int_of_nat"

#sys_int_of_nat (nat, #0, #2);;

Evaluation Failed: failure "sys_int_of_nat"

#int_of_nat (make_nat #2);;
0 : int
\end{verbatim}
\end{small}

\verb"nat_of_int" converts its argument into a nat unless it is negative.

\exple
\begin{small}
\begin{verbatim}
#nat_of_int #0;;
#<0> : nat

#nat_of_int #1;;
#<1> : nat

#nat_of_int #-1;;

Evaluation Failed: failure "nat_of_int"
\end{verbatim}
\end{small}
