\begin{caml_primitive}
arith_status : unit -> unit
\end{caml_primitive}
\verb"arith_status ()" prints the current status of each arithmetic flag
and recall how to manage it. 

\exple
\begin{small}
\begin{verbatim}
#arith_status();;

Standard arithmetic --> ON
     (returned by arith_is_standard ())
     (modifiable with #standard arith <your choice>)

Fast arithmetic --> OFF
     (returned by arith_is_fast ())
     (modifiable with #fast arith <your choice>)

Open arithmetic --> OFF
     (returned by arith_is_open ())
     (modifiable with #open arith)

Cautious arithmetic --> OFF
     (returned by arith_is_cautious ())
     (modifiable with #arith cautious)

Arithmetic overloading --> no overloading on numbers
     (returned by get_arith_overloading ())
     (modifiable with #arith overloading or #arith <the numerical type to be added>)

Normalization during computation --> OFF
     (returned by get_normalize_ratio ())
     (modifiable with set_normalize_ratio <your choice>)

Normalization when printing --> ON
     (returned by get_normalize_ratio_when_printing ())
     (modifiable with set_normalize_ratio_when_printing <your choice>)

Floating point approximation when printing rational numbers --> ON
     (returned by get_approx_printing ())
     (modifiable with set_approx_printing <your choice>)
  Default precision = 2
     (returned by get_floating_precision ())
     (modifiable with set_floating_precision <your choice>)

Error when a rational denominator is null --> ON
     (returned by get_error_when_null_denominator ())
     (modifiable with set_error_when_null_denominator <your choice>)
() : unit
\end{verbatim}
\end{small}
